/********************************************************************************
 * Copyright (c) 2017, 2018 Bosch Connected Devices and Solutions GmbH.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * Contributors:
 *    Bosch Connected Devices and Solutions GmbH - initial contribution
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/

/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.mita.platform.scoping

import com.google.inject.Inject
import java.util.Collections
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.mita.base.expressions.ElementReferenceExpression
import org.eclipse.mita.base.expressions.Expression
import org.eclipse.mita.base.expressions.FeatureCall
import org.eclipse.mita.base.types.ComplexType
import org.eclipse.mita.base.types.EnumerationType
import org.eclipse.mita.base.types.SumType
import org.eclipse.mita.base.types.TypesPackage
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer
import org.eclipse.mita.platform.ConfigurationItem
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.FilteringScope
import org.eclipse.xtext.scoping.impl.ImportNormalizer
import org.eclipse.xtext.scoping.impl.ImportScope
import org.eclipse.xtext.naming.IQualifiedNameProvider

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
class PlatformDSLScopeProvider extends AbstractPlatformDSLScopeProvider {

	@Inject
	private ITypeSystemInferrer typeInferrer;
	@Inject
	IQualifiedNameProvider qualifiedNameProvider;

	def IScope scope_ElementReferenceExpression_reference(EObject context, EReference ref) {
		val configItem = EcoreUtil2.getContainerOfType(context, ConfigurationItem);
		val typ = configItem?.type;
		val superScope = delegate.getScope(context, ref);
		if(typ instanceof SumType) {
			return Scopes.scopeFor(typ.alternatives);
		}
		return superScope;
	}

	def IScope scope_FeatureCall_feature(FeatureCall context, EReference reference) {
		val owner = context.owner;
		var EObject element = owner.element;
		
		if (element === null) {
			return getDelegate().getScope(context, reference);
		}

		val scope = IScope.NULLSCOPE;
		val result = typeInferrer.infer(owner);
		val ownerType = result?.type;
		
		return addScopeForType(ownerType, scope);
	}

	def dispatch IScope addScopeForType(EnumerationType type, IScope scope) {
		return Scopes.scopeFor(type.getEnumerator(), scope);
	}

	def dispatch IScope addScopeForType(ComplexType type, IScope scope) {
		return Scopes.scopeFor(type.getAllFeatures(), scope);
	}
	
	def dispatch IScope addScopeForType(Void type, IScope scope) {
		return scope;
	}
	
	def dispatch getElement(Expression it) {
		null
	}
	
	def dispatch getElement(ElementReferenceExpression it) {
		reference
	}
	
	def dispatch getElement(FeatureCall it) {
		feature
	}
}
