/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Bmg160Generator
extends AbstractSystemResourceGenerator {
    public static final String CONFIG_ITEM_POWER_MODE = "power_mode";
    public static final String CONFIG_ITEM_STANDBY_TIME = "standby_time";
    public static final String CONFIG_ITEM_TEMPERATURE_OVERSAMPLING = "temperature_oversampling";
    public static final String CONFIG_ITEM_PRESSURE_OVERSAMPLING = "pressure_oversampling";
    public static final String CONFIG_ITEM_HUMIDITY_OVERSAMPLING = "humidity_oversampling";
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_init(xdkGyroscope_BMG160_Handle);");
                _builder.newLine();
                CharSequence _generateExceptionHandler = Bmg160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmg160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Set Bandwidth */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setBandwidth(xdkGyroscope_BMG160_Handle, ");
                String _bmgBandwidthEnumValue = Bmg160Generator.this.getBmgBandwidthEnumValue(Bmg160Generator.this.configuration);
                _builder.append((Object)_bmgBandwidthEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler_1 = Bmg160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmg160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Set Powermode */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setMode(xdkGyroscope_BMG160_Handle, GYROSCOPE_BMG160_POWERMODE_NORMAL);");
                _builder.newLine();
                CharSequence _generateExceptionHandler_2 = Bmg160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmg160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Set Range */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setRange(xdkGyroscope_BMG160_Handle, ");
                String _bmgRangeEnumValue = Bmg160Generator.this.getBmgRangeEnumValue(Bmg160Generator.this.configuration);
                _builder.append((Object)_bmgRangeEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler_3 = Bmg160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmg160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_3);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 750).addHeader("XdkSensorHandle.h", true).addHeader("BCDS_Gyroscope.h", true);
    }

    public String getBmgBandwidthEnumValue(IComponentConfiguration config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GYROSCOPE_BMG160_BANDWIDTH_");
        Enumerator _enumerator = config.getEnumerator("bandwidth");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        String _substring = _upperCase.substring(3);
        _builder.append(_substring);
        return _builder.toString();
    }

    public String getBmgRangeEnumValue(IComponentConfiguration config) {
        String _plus;
        String _xblockexpression = null;
        Enumerator _enumerator = config.getEnumerator("range");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        String enumVal = _upperCase;
        String _substring = null;
        if (enumVal != null) {
            int _length = enumVal.length();
            int _minus = _length - 1;
            _substring = enumVal.substring(0, _minus);
        }
        enumVal = _plus = String.valueOf(_substring) + "s";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GYROSCOPE_BMG160_");
        _builder.append(enumVal);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Gyroscope_XyzData_T ");
                String _dataVariable = Bmg160Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = Gyroscope_readXyzValue(xdkGyroscope_BMG160_Handle, &");
                String _dataVariable_1 = Bmg160Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Bmg160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmg160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Gyroscope.h", true).addHeader("XdkSensorHandle.h", true);
    }

    public String getDataVariable(ModalityAccessPreparation preparation) {
        return StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)preparation));
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modalityAccess) {
        final String dataVariable = this.getDataVariable(modalityAccess.getPreparation());
        String modalityName = modalityAccess.getModality().getName();
        CodeFragment _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)modalityName, (Object)"x_axis")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".xAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"y_axis")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".yAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"z_axis")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".zAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        return _switchResult;
    }
}

