/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;

public class WlanValidator
implements IResourceValidator {
    private static final Pattern IPV4_ADDR_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            this.validateNetworkConfig((SystemResourceSetup)context, acceptor);
        }
    }

    protected void validateNetworkConfig(SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        Procedures.Procedure1<EObject> _function;
        Expression ipConfigExpr = setup.getConfigurationItemValueOrDefault("ipConfiguration");
        Object ipConfig = StaticValueInferrer.infer((EObject)ipConfigExpr, (Procedures.Procedure1)(_function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }));
        if (ipConfig instanceof StaticValueInferrer.SumTypeRepr) {
            boolean staticConfig = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)ipConfig).name, (Object)"Static");
            if (staticConfig) {
                List<String> staticNetworkConfigItems = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"ip", "subnetMask", "gateway", "dns"}));
                for (String item : staticNetworkConfigItems) {
                    this.validateConfigItemIsValidIpAddress(setup, (StaticValueInferrer.SumTypeRepr)ipConfig, item, acceptor);
                }
            }
        } else {
            acceptor.acceptError("Bad constructor", (EObject)ipConfigExpr, null, 0, "VALIDATION_UNKNOWN_CONSTRUCTOR", new String[0]);
        }
    }

    protected void validateConfigItemIsValidIpAddress(SystemResourceSetup setup, StaticValueInferrer.SumTypeRepr staticConf, String item, ValidationMessageAcceptor acceptor) {
        Expression itemValue = (Expression)staticConf.properties.get(item);
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object value = StaticValueInferrer.infer((EObject)itemValue, (Procedures.Procedure1)_function);
        boolean _xifexpression = false;
        _xifexpression = value instanceof String ? IPV4_ADDR_PATTERN.matcher((CharSequence)value).matches() : false;
        boolean isValidIpAddress = _xifexpression;
        if (!isValidIpAddress) {
            acceptor.acceptError(String.valueOf(item) + " must be a valid IPv4 address", (EObject)itemValue, null, 0, "network_" + item + "_must_be_ipv4", new String[0]);
        }
    }
}

