/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class LedGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public static Map<SignalInstance, String> getSignalToColorAssignment(SystemResourceSetup context) {
        final HashMap<SignalInstance, String> result = new HashMap<SignalInstance, String>();
        Consumer<SignalInstance> _function = new Consumer<SignalInstance>(){

            @Override
            public void accept(SignalInstance vciv) {
                Expression _initialization = vciv.getInitialization();
                Functions.Function1<ElementReferenceExpression, Expression> _function = new Functions.Function1<ElementReferenceExpression, Expression>(){

                    public Expression apply(ElementReferenceExpression x) {
                        EObject _reference = x.getReference();
                        return ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)x, (String)"color");
                    }
                };
                Functions.Function1<Expression, Object> _function_1 = new Functions.Function1<Expression, Object>(){

                    public Object apply(Expression it) {
                        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                            public void apply(EObject it) {
                            }
                        };
                        return StaticValueInferrer.infer((EObject)it, (Procedures.Procedure1)_function);
                    }
                };
                Functions.Function1<Enumerator, String> _function_2 = new Functions.Function1<Enumerator, String>(){

                    public String apply(Enumerator it) {
                        return it.getName();
                    }
                };
                String color = (String)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)Iterables.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{_initialization})), ElementReferenceExpression.class), (Functions.Function1)_function), (Functions.Function1)_function_1), Enumerator.class), (Functions.Function1)_function_2));
                result.put(vciv, color);
            }
        };
        context.getSignalInstances().forEach((Consumer)_function);
        return result;
    }

    public CodeFragment generateSetup() {
        CodeFragment _xblockexpression = null;
        final Set colors = IterableExtensions.toSet(LedGenerator.getSignalToColorAssignment(this.setup).values());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T ledSetupStatus = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"ledSetupStatus = BSP_LED_Connect();");
                _builder.newLine();
                _builder.append((Object)"if(ledSetupStatus != RETCODE_OK)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return ledSetupStatus;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                for (String color : colors) {
                    _builder.newLine();
                    _builder.append((Object)"ledSetupStatus = BSP_LED_Enable((uint32_t) ");
                    String _handle = LedGenerator.getHandle(color);
                    _builder.append((Object)_handle);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(ledSetupStatus != RETCODE_OK)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ledSetupStatus;");
                    _builder.newLine();
                    _builder.append((Object)"} \t\t");
                    _builder.newLine();
                }
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                for (String color : colors) {
                    _builder.append((Object)"static bool ");
                    CharSequence _statusVariable = LedGenerator.getStatusVariable(color);
                    _builder.append((Object)_statusVariable);
                    _builder.append((Object)" = false;");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        _xblockexpression = _create.setPreamble(_client_1).addHeader("BSP_BoardType.h", true, 750).addHeader("BCDS_BSP_LED.h", true).addHeader("BCDS_Retcode.h", true);
        return _xblockexpression;
    }

    private static CharSequence getStatusVariable(String color) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_ledStatus");
        String _firstUpper = StringExtensions.toFirstUpper((String)color);
        _builder.append(_firstUpper);
        return _builder;
    }

    private static String getHandle(String color) {
        String _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)color, (Object)"Orange")) {
            _matched = true;
            _switchResult = "BSP_XDK_LED_O";
        }
        if (!_matched && Objects.equal((Object)color, (Object)"Yellow")) {
            _matched = true;
            _switchResult = "BSP_XDK_LED_Y";
        }
        if (!_matched && Objects.equal((Object)color, (Object)"Red")) {
            _matched = true;
            _switchResult = "BSP_XDK_LED_R";
        }
        return _switchResult;
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceSetter(SignalInstance signalInstance, final String valueVariableName) {
        CodeFragment _xblockexpression = null;
        final String color = LedGenerator.getSignalToColorAssignment(this.setup).get(signalInstance);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(*");
                _builder.append((Object)valueVariableName);
                _builder.append((Object)" == TRUE) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"BSP_LED_Switch((uint32_t) ");
                String _handle = LedGenerator.getHandle(color);
                _builder.append((Object)_handle, "\t");
                _builder.append((Object)", (uint32_t) BSP_LED_COMMAND_ON);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BSP_LED_Switch((uint32_t) ");
                String _handle_1 = LedGenerator.getHandle(color);
                _builder.append((Object)_handle_1, "\t");
                _builder.append((Object)", (uint32_t) BSP_LED_COMMAND_OFF);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                CharSequence _statusVariable = LedGenerator.getStatusVariable(color);
                _builder.append((Object)_statusVariable);
                _builder.append((Object)" = *");
                _builder.append((Object)valueVariableName);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client);
        return _xblockexpression;
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance signalInstance, final String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"*");
                _builder.append((Object)resultName);
                _builder.append((Object)" = ");
                CharSequence _statusVariable = LedGenerator.getStatusVariable(LedGenerator.getSignalToColorAssignment(LedGenerator.this.setup).get(signalInstance));
                _builder.append((Object)_statusVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

