/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.scoping;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.xtext.mwe.ResourceDescriptionsProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProgramDslImportScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;

    protected String getImportedNamespace(EObject object) {
        if (object instanceof ImportStatement) {
            String _importedNamespace = ((ImportStatement)object).getImportedNamespace();
            return String.valueOf(_importedNamespace) + ".*";
        }
        return super.getImportedNamespace(object);
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        ImportNormalizer _createImportedNamespaceResolver = this.createImportedNamespaceResolver("stdlib.*", ignoreCase);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ImportNormalizer[]{_createImportedNamespaceResolver}));
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        List superImports = super.internalGetImportedNamespaceResolvers(context, ignoreCase);
        if (context instanceof PackageAssociation) {
            String _name = ((PackageAssociation)context).getName();
            String _plus = String.valueOf(_name) + ".*";
            ImportNormalizer _createImportedNamespaceResolver = this.createImportedNamespaceResolver(_plus, ignoreCase);
            superImports.add(_createImportedNamespaceResolver);
        }
        return superImports;
    }

    protected ISelectable internalGetAllDescriptions(Resource resource) {
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.get(resource.getResourceSet());
        IResourceDescription thisResourceDescription = resourceDescriptions.getResourceDescription(resource.getURI());
        if (thisResourceDescription == null) {
            return super.internalGetAllDescriptions(resource);
        }
        List visibleContainers = this.containerManager.getVisibleContainers(thisResourceDescription, resourceDescriptions);
        Functions.Function1<IContainer, Iterable<IEObjectDescription>> _function = new Functions.Function1<IContainer, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IContainer x) {
                return x.getExportedObjects();
            }
        };
        Iterable exportedObjects = Iterables.concat((Iterable)ListExtensions.map((List)visibleContainers, (Functions.Function1)_function));
        return new MultimapBasedSelectable(exportedObjects);
    }
}

