/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.generator.IPlatformStartupGenerator;
import org.eclipse.mita.program.generator.internal.UserCodeFileGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EntryPointGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject(optional=true)
    protected IPlatformStartupGenerator startupGenerator;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject(optional=true)
    protected IPlatformEventLoopGenerator eventLoopGenerator;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected UserCodeFileGenerator userCodeGenerator;

    public CompositeGeneratorNode generateMain(final CompilationContext context) {
        CompositeGeneratorNode _xblockexpression = null;
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                return it instanceof AbstractSystemResource || it instanceof SystemResourceSetup;
            }
        };
        final List allResourcesUsed = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.filter(context.getResourceGraph().getNodesInTopolicalOrder(), (Functions.Function1)_function), EObject.class));
        LinkedList<CodeFragment.IncludePath> baseIncludes = new LinkedList<CodeFragment.IncludePath>();
        CodeFragment.IncludePath _includePath = new CodeFragment.IncludePath("MitaExceptions.h", false);
        baseIncludes.add(_includePath);
        CodeFragment.IncludePath _includePath_1 = new CodeFragment.IncludePath("MitaEvents.h", false);
        baseIncludes.add(_includePath_1);
        boolean _hasTimeEvents = context.hasTimeEvents();
        if (_hasTimeEvents) {
            CodeFragment.IncludePath _includePath_2 = new CodeFragment.IncludePath("MitaTime.h", false);
            baseIncludes.add(_includePath_2);
        }
        for (EObject systemResource : allResourcesUsed) {
            String _fileBasename = this._generatorUtils.getFileBasename(systemResource);
            String _plus = String.valueOf(_fileBasename) + ".h";
            CodeFragment.IncludePath _includePath_3 = new CodeFragment.IncludePath(_plus, false);
            baseIncludes.add(_includePath_3);
        }
        Functions.Function1<Program, Boolean> _function_1 = new Functions.Function1<Program, Boolean>(){

            public Boolean apply(Program it) {
                return EntryPointGenerator.this._generatorUtils.containsCodeRelevantContent(it);
            }
        };
        Iterable _filter = IterableExtensions.filter(context.getAllUnits(), (Functions.Function1)_function_1);
        for (Program program : _filter) {
            String _resourceBaseName = UserCodeFileGenerator.getResourceBaseName(program);
            String _plus_1 = String.valueOf(_resourceBaseName) + ".h";
            CodeFragment.IncludePath _includePath_4 = new CodeFragment.IncludePath(_plus_1, false);
            baseIncludes.add(_includePath_4);
        }
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                _builder.append((Object)"int main(void)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateMain = EntryPointGenerator.this.startupGenerator.generateMain(context);
                _builder.append((Object)_generateMain, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" Mita_initialize(");
                CodeFragment _generateEventLoopHandlerSignature = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
                _builder.append((Object)_generateEventLoopHandlerSignature);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateEventLoopHandlerPreamble = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerPreamble(context, null);
                _builder.append((Object)_generateEventLoopHandlerPreamble, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)exceptionType, "\t");
                _builder.append((Object)" exception = NO_EXCEPTION;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateSetupPreamble = EntryPointGenerator.this.eventLoopGenerator.generateSetupPreamble(context);
                _builder.append((Object)_generateSetupPreamble, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                boolean _isEmpty = allResourcesUsed.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"// setup resources");
                    _builder.newLine();
                    for (EObject resource : allResourcesUsed) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"exception = ");
                        String _setupName = EntryPointGenerator.this._generatorUtils.getSetupName(resource);
                        _builder.append((Object)_setupName, "\t");
                        _builder.append((Object)"();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        CodeFragment _generateLoggingExceptionHandler = EntryPointGenerator.this._generatorUtils.generateLoggingExceptionHandler(EntryPointGenerator.this._generatorUtils.getBaseName(resource), "setup");
                        _builder.append((Object)_generateLoggingExceptionHandler, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.newLine();
                    }
                    _builder.newLine();
                    boolean _hasTimeEvents = context.hasTimeEvents();
                    if (_hasTimeEvents) {
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"// setup time");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"exception = SetupTime();");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        CodeFragment _generateLoggingExceptionHandler_1 = EntryPointGenerator.this._generatorUtils.generateLoggingExceptionHandler("Time", "setup");
                        _builder.append((Object)_generateLoggingExceptionHandler_1, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" Mita_goLive(");
                CodeFragment _generateEventLoopHandlerSignature_1 = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
                _builder.append((Object)_generateEventLoopHandlerSignature_1);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateEventLoopHandlerPreamble_1 = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerPreamble(context, null);
                _builder.append((Object)_generateEventLoopHandlerPreamble_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)exceptionType, "\t");
                _builder.append((Object)" exception = NO_EXCEPTION;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateEnablePreamble = EntryPointGenerator.this.eventLoopGenerator.generateEnablePreamble(context);
                _builder.append((Object)_generateEnablePreamble, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                boolean _hasTimeEvents_1 = context.hasTimeEvents();
                if (_hasTimeEvents_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = EnableTime();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    Object _generateLoggingExceptionHandler_2 = EntryPointGenerator.this._generatorUtils.generateLoggingExceptionHandler("Time", "enable");
                    _builder.append(_generateLoggingExceptionHandler_2, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                }
                for (EObject resource_1 : allResourcesUsed) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = ");
                    String _enableName = EntryPointGenerator.this._generatorUtils.getEnableName(resource_1);
                    _builder.append((Object)_enableName, "\t");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    CodeFragment _generateLoggingExceptionHandler_3 = EntryPointGenerator.this._generatorUtils.generateLoggingExceptionHandler(EntryPointGenerator.this._generatorUtils.getBaseName(resource_1), "enable");
                    _builder.append((Object)_generateLoggingExceptionHandler_3, "\t");
                    _builder.newLineIfNotEmpty();
                }
                Iterable<Program> _allUnits = context.getAllUnits();
                for (Program program : _allUnits) {
                    boolean _not_1;
                    boolean _isEmpty_1 = program.getGlobalVariables().isEmpty();
                    boolean bl2 = _not_1 = !_isEmpty_1;
                    if (!_not_1) continue;
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = ");
                    String _globalInitName = EntryPointGenerator.this._generatorUtils.getGlobalInitName(program);
                    _builder.append((Object)_globalInitName, "\t");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    CodeFragment _generateLoggingExceptionHandler_4 = EntryPointGenerator.this._generatorUtils.generateLoggingExceptionHandler(EntryPointGenerator.this._generatorUtils.getGlobalInitName(program), "do");
                    _builder.append((Object)_generateLoggingExceptionHandler_4, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"return NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static ");
                _builder.append((Object)exceptionType);
                _builder.append((Object)" Mita_initialize(");
                CodeFragment _generateEventLoopHandlerSignature = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
                _builder.append((Object)_generateEventLoopHandlerSignature);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"static ");
                _builder.append((Object)exceptionType);
                _builder.append((Object)" Mita_goLive(");
                CodeFragment _generateEventLoopHandlerSignature_1 = EntryPointGenerator.this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
                _builder.append((Object)_generateEventLoopHandlerSignature_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        };
        _xblockexpression = _create.setPreamble(_client_1).addHeader((CodeFragment.IncludePath[])Conversions.unwrapArray(baseIncludes, CodeFragment.IncludePath.class)).toImplementation(context);
        return _xblockexpression;
    }

    public CompositeGeneratorNode generateEventHeader(final CompilationContext context) {
        final CodeFragment handlerSignature = this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _generateEventHeaderPreamble = EntryPointGenerator.this.eventLoopGenerator.generateEventHeaderPreamble(context);
                _builder.append((Object)_generateEventHeaderPreamble);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                Iterable<EventHandlerDeclaration> _allEventHandlers = context.getAllEventHandlers();
                for (EventHandlerDeclaration handler : _allEventHandlers) {
                    _builder.append((Object)exceptionType);
                    _builder.append((Object)" ");
                    String _handlerName = EntryPointGenerator.this._generatorUtils.getHandlerName(handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"(");
                    _builder.append((Object)handlerSignature);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).toHeader(context, "Mita_EVENTS_H");
    }
}

