/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.x86.platform;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EventLoopGenerator
implements IPlatformEventLoopGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment generateEventloopInject(final String functionName, String userParam1, String userParam2) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)functionName);
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEventloopInject(String functionName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("NULL");
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("0");
        return this.generateEventloopInject(functionName, _builder.toString(), _builder_1.toString());
    }

    public CodeFragment generateEventLoopInject(CompilationContext context, String functionName) {
        return this.generateEventloopInject(functionName);
    }

    public CodeFragment generateEventLoopStart(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEventHeaderPreamble(final CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

                    public Boolean apply(EventHandlerDeclaration it) {
                        EventSource _event = it.getEvent();
                        return _event instanceof SystemEventSource;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)context.getAllEventHandlers(), (Functions.Function1)_function);
                for (EventHandlerDeclaration handler : _filter) {
                    _builder.append((Object)"volatile bool ");
                    String _handlerName = EventLoopGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag;");
                    _builder.newLineIfNotEmpty();
                }
                Iterable _allTimeEvents = EventLoopGenerator.this._generatorUtils.getAllTimeEvents(context);
                for (EventHandlerDeclaration handler_1 : _allTimeEvents) {
                    EventSource _event = handler_1.getEvent();
                    int period = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)_event));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int32_t lastTick");
                    String _firstUpper = StringExtensions.toFirstUpper((String)Integer.valueOf(period).toString());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("stdbool.h", true);
    }

    public CodeFragment generateEventLoopHandlerSignature(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEventLoopHandlerPreamble(CompilationContext context, EventHandlerDeclaration handler) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSetupPreamble(CompilationContext context) {
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration it) {
                EventSource _event = it.getEvent();
                return _event instanceof SystemEventSource;
            }
        };
        Functions.Function1<EventHandlerDeclaration, Boolean> _function_1 = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration it) {
                EventSource _event = it.getEvent();
                String _name = ((SystemEventSource)_event).getSource().getName();
                return Objects.equal((Object)_name, (Object)"startup");
            }
        };
        final EventHandlerDeclaration startupEventHandler = (EventHandlerDeclaration)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)context.getAllEventHandlers(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (startupEventHandler != null) {
                    String _handlerName = EventLoopGenerator.this._generatorUtils.getHandlerName((EObject)startupEventHandler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag = 1;");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEnablePreamble(CompilationContext context) {
        return CodeFragment.EMPTY;
    }
}

