/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.ApplicationScopedEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ApplicationScopedInjectionTest
extends Arquillian {
    private static String token1;
    private static String token2;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = ApplicationScopedInjectionTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = ApplicationScopedInjectionTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ApplicationScopedInjectionTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(ApplicationScopedEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        token1 = TokenUtils.generateTokenString((String)"/Token1.json");
        token2 = TokenUtils.generateTokenString((String)"/Token2.json");
    }

    @RunAsClient
    @Test(groups={"cdi"}, description="Verify that the raw token injected as claim value is as expected")
    public void verifyInjectedRawTokenClaimValue() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawTokenClaimValue\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawTokenClaimValue";
        this.verifyInjectedToken(uri, token1);
        this.verifyInjectedToken(uri, token2);
    }

    @RunAsClient
    @Test(groups={"cdi"}, description="Verify that JsonWebToken.getRawToken returns the raw token as expected")
    public void verifyInjectedRawTokenJwt() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawTokenJwt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawTokenJwt";
        this.verifyInjectedToken(uri, token1);
        this.verifyInjectedToken(uri, token2);
    }

    @RunAsClient
    @Test(groups={"cdi"}, description="Verify that the raw token injected as provider is as expected")
    public void verifyInjectedRawToken1Provider() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawTokenProvider\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawTokenProvider";
        this.verifyInjectedToken(uri, token1);
        this.verifyInjectedToken(uri, token2);
    }

    private void verifyInjectedToken(String uri, String token) {
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
        Assert.assertEquals((String)reply.getString("injectedRawToken"), (String)token);
    }
}

