/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic.execution;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.tck.dynamic.DynamicPaths;
import org.eclipse.microprofile.graphql.tck.dynamic.execution.TestData;
import org.testng.annotations.DataProvider;

public class GraphQLTestDataProvider {
    private static final Logger LOG = Logger.getLogger(GraphQLTestDataProvider.class.getName());

    private GraphQLTestDataProvider() {
    }

    @DataProvider(name="specification")
    public static Object[][] getSpecificationTestData() {
        if (!GraphQLTestDataProvider.disableSpecificationTests()) {
            return GraphQLTestDataProvider.getTestData(DataFrom.specification);
        }
        return GraphQLTestDataProvider.toObjectArray(Collections.EMPTY_LIST);
    }

    @DataProvider(name="implementation")
    public static Object[][] getImplementationTestData() {
        return GraphQLTestDataProvider.getTestData(DataFrom.implementation);
    }

    private static Object[][] getTestData(DataFrom dataFrom) {
        try {
            DirectoryStream<Path> directoryStream = null;
            directoryStream = dataFrom.equals((Object)DataFrom.specification) ? DynamicPaths.getDataForSpecification() : DynamicPaths.getDataForImplementation();
            Set<Path> testFolders = GraphQLTestDataProvider.toListOfPaths(directoryStream);
            List<TestData> testDataList = GraphQLTestDataProvider.toListOfTestData(testFolders);
            GraphQLTestDataProvider.sort(testDataList);
            return GraphQLTestDataProvider.toObjectArray(testDataList);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "No " + dataFrom.name() + " specific tests found [{0}]", ex.getMessage());
            return new Object[0][];
        }
    }

    private static List<TestData> toListOfTestData(Set<Path> testFolders) {
        ArrayList<TestData> testDataList = new ArrayList<TestData>();
        for (Path testFolder : testFolders) {
            if (testFolder.getFileName().toString().startsWith("META-INF")) continue;
            try {
                TestData testData = GraphQLTestDataProvider.toTestData(testFolder);
                if (testData.shouldIgnore() || testData.getInput().size() <= 0) continue;
                testDataList.add(testData);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Could not add test case {0} - {1}", new Object[]{testFolder.getFileName().toString(), ioe.getMessage()});
            }
        }
        return testDataList;
    }

    private static Object[][] toObjectArray(List<TestData> testDataList) {
        Object[][] testParameters = new Object[testDataList.size()][1];
        for (int row = 0; row < testDataList.size(); ++row) {
            TestData testData = testDataList.get(row);
            if (!testData.shouldIgnore()) {
                testParameters[row][0] = testData;
                continue;
            }
            LOG.log(Level.SEVERE, "Ignoring test [{0}]", testData.getName());
        }
        return testParameters;
    }

    private static void sort(List<TestData> testDataList) {
        Collections.sort(testDataList, new Comparator<TestData>(){

            @Override
            public int compare(TestData u1, TestData u2) {
                return u1.getPriority().compareTo(u2.getPriority());
            }
        });
    }

    private static TestData toTestData(Path folder) throws IOException {
        final TestData testData = new TestData(folder.getFileName().toString().replace("/", ""));
        Files.walkFileTree(folder, new HashSet<FileVisitOption>(), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    String filename = file.getFileName().toString();
                    if (filename.matches("output.*\\.json")) {
                        String content = GraphQLTestDataProvider.getFileContent(file);
                        testData.addOutput(content);
                    } else if (filename.matches("input.*\\.graphql")) {
                        String content = GraphQLTestDataProvider.getFileContent(file);
                        testData.addInput(content);
                    } else {
                        switch (filename) {
                            case "httpHeader.properties": {
                                Properties properties = new Properties();
                                properties.load(Files.newInputStream(file, new OpenOption[0]));
                                testData.setHttpHeaders(properties);
                                break;
                            }
                            case "variables.json": {
                                String content = GraphQLTestDataProvider.getFileContent(file);
                                testData.setVariables(GraphQLTestDataProvider.toJsonObject(content));
                                break;
                            }
                            case "test.properties": {
                                Properties properties = new Properties();
                                properties.load(Files.newInputStream(file, new OpenOption[0]));
                                testData.setProperties(properties);
                                break;
                            }
                            case "cleanup.graphql": {
                                String content = GraphQLTestDataProvider.getFileContent(file);
                                testData.setCleanup(content);
                                break;
                            }
                            case "prepare.graphql": {
                                String content = GraphQLTestDataProvider.getFileContent(file);
                                testData.setPrepare(content);
                                break;
                            }
                            default: {
                                LOG.log(Level.WARNING, "Ignoring unknown file {0}", filename);
                            }
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                LOG.log(Level.SEVERE, "Could not load file {0}[{1}]", new Object[]{file, exc.getMessage()});
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return testData;
    }

    private static String getFileContent(Path file) throws IOException {
        return new String(Files.readAllBytes(file));
    }

    private static Set<Path> toListOfPaths(DirectoryStream<Path> directoryStream) {
        HashSet<Path> directories = new HashSet<Path>();
        for (Path p : directoryStream) {
            try {
                Stream<Path> paths = Files.walk(p, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    Set tree = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
                    directories.addAll(tree);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (paths == null) continue;
                    if (throwable != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    paths.close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Ignoring directory [{0}] - {1}", new Object[]{p.getFileName().toString(), ex.getMessage()});
            }
        }
        return directories;
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    private static boolean disableSpecificationTests() {
        return Boolean.valueOf(System.getProperty("disableSpecificationTests", "false"));
    }

    private static enum DataFrom {
        implementation,
        specification;

    }
}

