/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Shape;
import org.eclipse.mylyn.mft.gmf.ui.figures.GradiatedColorRegistry;
import org.eclipse.swt.graphics.Color;

public class FigureManagerHelper {
    public static FigureManagerHelper INSTANCE = new FigureManagerHelper();

    private FigureManagerHelper() {
    }

    public void reveal(IFigure figure, double nearness) {
        int alpha = (int)(255.0 - (nearness *= 0.75) * 255.0);
        if (figure instanceof Shape) {
            ((Shape)figure).setAlpha(alpha);
        }
    }

    public void reveal(IFigure figure, Color color1, Color color2, double nearness) {
        if (figure instanceof Shape && !(figure instanceof PolylineConnection)) {
            this.reveal(figure, nearness);
        } else {
            figure.setForegroundColor(GradiatedColorRegistry.INSTANCE.getColor(color1, color2, (float)(nearness *= 0.75)));
        }
    }

    public void unreveal(IFigure figure) {
        if (figure instanceof Shape && !(figure instanceof PolylineConnection)) {
            ((Shape)figure).setAlpha(255);
        }
    }

    public void unreveal(IFigure figure, Color maskingColor) {
        if (figure instanceof Shape && !(figure instanceof PolylineConnection)) {
            this.unreveal(figure);
        } else {
            figure.setForegroundColor(maskingColor);
        }
    }
}

