/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecorator;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecoratorProvider;
import org.eclipse.mylyn.mft.gmf.ui.figures.FigureManagerHelper;
import org.eclipse.mylyn.mft.gmf.ui.figures.IRevealableFigure;

public class NodeDecorator
extends ContextDecorator {
    private final EObject domainObject;

    public NodeDecorator(ContextDecoratorProvider provider, IDecoratorTarget target, EObject domainObject) {
        super(provider, target);
        this.domainObject = domainObject;
    }

    @Override
    protected void createDecoration() {
        this.removeDecorations();
        if (!this.isInteresting()) {
            IFigure decorated = this.getEditPart().getFigure();
            NodeMaskingFigure decorationFigure = new NodeMaskingFigure(decorated);
            this.addDecoration(decorationFigure);
        } else if (this.isLandmark()) {
            IFigure decorated = this.getEditPart().getFigure();
            this.addDecoration(new NodeLandmarkFigure(decorated));
        }
    }

    private IGraphicalEditPart getDecoratedParent(IGraphicalEditPart part) {
        IGraphicalEditPart backgroundPart = part;
        while (backgroundPart.getParent() instanceof IGraphicalEditPart) {
            backgroundPart = (IGraphicalEditPart)backgroundPart.getParent();
            Object object = this.getProvider().getDomainObject(backgroundPart);
            if (this.getProvider().getDomainUIBridge().acceptsViewObject(object, (Object)backgroundPart)) break;
        }
        return backgroundPart;
    }

    private IGraphicalEditPart getDecoratedInterestingParent(IGraphicalEditPart part) {
        IGraphicalEditPart backgroundPart = part;
        while (backgroundPart.getParent() instanceof IGraphicalEditPart) {
            backgroundPart = (IGraphicalEditPart)backgroundPart.getParent();
            if (this.getProvider().isInteresting(backgroundPart)) break;
        }
        return backgroundPart;
    }

    @Override
    public boolean isInteresting() {
        return this.getProvider().isInteresting(this.domainObject) || this.getProvider().isLandmark(this.domainObject);
    }

    @Override
    public boolean isLandmark() {
        return this.getProvider().isLandmark(this.domainObject);
    }

    public class NodeLandmarkFigure
    extends RectangleFigure
    implements IRevealableFigure,
    Locator {
        private static final int BORDER_SIZE = 2;
        private final IFigure decorated;

        public NodeLandmarkFigure(IFigure decorated) {
            this.decorated = decorated;
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.setOpaque(false);
            this.setFill(false);
            this.setOutline(true);
            this.setForegroundColor(ColorConstants.gray);
            this.setLineWidth(2);
            this.setAlpha(255);
        }

        public void relocate(IFigure target) {
            if (target instanceof Decoration) {
                Rectangle borderBounds = this.decorated.getBounds().getCopy();
                borderBounds = new Rectangle(borderBounds.x - 1, borderBounds.y - 2, borderBounds.width, 2);
                target.setBounds(borderBounds);
                ((IFigure)target.getChildren().get(0)).setBounds(borderBounds);
            }
        }

        public void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
        }

        @Override
        public void reveal(double nearness) {
        }

        @Override
        public void unreveal() {
        }

        @Override
        public void restore() {
        }
    }

    class NodeMaskingFigure
    extends RectangleFigure
    implements IRevealableFigure {
        private final IFigure decorated;

        public NodeMaskingFigure(IFigure decorated) {
            this.decorated = decorated;
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.setOpaque(true);
            this.setFill(true);
            this.setOutline(false);
            IGraphicalEditPart backgroundPart = NodeDecorator.this.getDecoratedInterestingParent(NodeDecorator.this.getEditPart());
            if (backgroundPart instanceof ShapeNodeEditPart) {
                this.setBackgroundColor(ColorConstants.white);
            } else {
                this.setBackgroundColor(backgroundPart.getFigure().getBackgroundColor());
            }
            this.setAlpha(255);
        }

        @Override
        public void reveal(double nearness) {
            FigureManagerHelper.INSTANCE.reveal(this, nearness);
        }

        @Override
        public void unreveal() {
            FigureManagerHelper.INSTANCE.unreveal(this);
        }

        @Override
        public void restore() {
        }

        public void relocate(IFigure target) {
            if (target instanceof Decoration) {
                Rectangle bounds = this.decorated.getBounds().getCopy();
                IGraphicalEditPart backgroundPart = NodeDecorator.this.getDecoratedParent(NodeDecorator.this.getEditPart());
                if (backgroundPart instanceof ShapeNodeEditPart) {
                    IFigure donorFigure = (IFigure)backgroundPart.getFigure().getChildren().get(0);
                    bounds.width = donorFigure.getBounds().width - 4;
                    bounds.x = donorFigure.getBounds().x + 2;
                }
                target.setBounds(bounds);
                ((IFigure)target.getChildren().get(0)).setBounds(bounds);
            }
        }
    }
}

