/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.Maven;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.Bundles;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEmbeddedRuntime
extends AbstractMavenRuntime {
    private static final String MAVEN_CORE_POM_PROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(MavenEmbeddedRuntime.class);
    private static final String MAVEN_EXECUTOR_CLASS = MavenCli.class.getName();
    public static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static List<String> LAUNCHER_CLASSPATH;
    private static List<String> CLASSPATH;
    private static volatile String mavenVersion;

    public MavenEmbeddedRuntime() {
        super("EMBEDDED");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getLocation() {
        return "EMBEDDED";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void createLauncherConfiguration(AbstractMavenRuntime.IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
        this.initClasspath();
        collector.addRealm("]launcher");
        for (String entry : LAUNCHER_CLASSPATH) {
            collector.addArchiveEntry(entry);
        }
        collector.addRealm(PLEXUS_CLASSWORLD_NAME);
        this.collectExtensions(collector, monitor);
        for (String entry : CLASSPATH) {
            if (entry.contains("plexus-build-api")) continue;
            collector.addArchiveEntry(entry);
        }
    }

    private synchronized void initClasspath() {
        if (CLASSPATH == null) {
            Bundle mavenRuntimeBundle = MavenEmbeddedRuntime.findMavenEmbedderBundle();
            LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
            this.addBundleClasspathEntries(allEntries, mavenRuntimeBundle, true);
            LinkedHashSet bundles = new LinkedHashSet();
            ArrayList requiredWires = new ArrayList();
            BundleWiring wiring = (BundleWiring)mavenRuntimeBundle.adapt(BundleWiring.class);
            requiredWires.addAll(wiring.getRequiredWires("osgi.wiring.bundle"));
            requiredWires.addAll(wiring.getRequiredWires("osgi.wiring.package"));
            requiredWires.stream().map(BundleWire::getProvider).map(BundleReference::getBundle).forEach(bundles::add);
            for (Bundle bundle : bundles) {
                this.addBundleClasspathEntries(allEntries, bundle, false);
            }
            ArrayList cp = new ArrayList();
            ArrayList<String> lcp = new ArrayList<String>();
            for (String entry : allEntries) {
                ArrayList<String> path = entry.contains("plexus-classworlds") ? lcp : cp;
                path.add(entry);
            }
            CLASSPATH = List.copyOf(cp);
            LAUNCHER_CLASSPATH = List.copyOf(lcp);
        }
    }

    private void addBundleClasspathEntries(Set<String> entries, Bundle bundle, boolean addFragments) {
        Bundle[] fragments;
        entries.addAll(Bundles.getClasspathEntries(bundle));
        if (addFragments && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                entries.addAll(Bundles.getClasspathEntries(fragment));
                ++n2;
            }
        }
    }

    private static Bundle findMavenEmbedderBundle() {
        return FrameworkUtil.getBundle(Maven.class);
    }

    public String toString() {
        Bundle embedder = MavenEmbeddedRuntime.findMavenEmbedderBundle();
        return embedder != null ? String.valueOf(this.getVersion()) + '/' + embedder.getVersion() : "org.eclipse.m2e.maven.runtime";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getVersion() {
        if (mavenVersion != null) {
            return mavenVersion;
        }
        this.initClasspath();
        try {
            String version;
            Properties pomProperties;
            block20: {
                Throwable throwable;
                String mavenCoreJarPath = CLASSPATH.stream().filter(p -> p.contains("maven-core")).findFirst().orElseThrow(() -> new IllegalStateException("Could not find maven core jar file"));
                pomProperties = new Properties();
                Path mavenCoreJar = Path.of(mavenCoreJarPath, new String[0]);
                if (Files.isRegularFile(mavenCoreJar, new LinkOption[0])) {
                    throwable = null;
                    Object var5_8 = null;
                    try (ZipFile zip = new ZipFile(mavenCoreJarPath);){
                        ZipEntry zipEntry = zip.getEntry(MAVEN_CORE_POM_PROPERTIES);
                        if (zipEntry != null) {
                            pomProperties.load(zip.getInputStream(zipEntry));
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                if (Files.isDirectory(mavenCoreJar, new LinkOption[0])) {
                    throwable = null;
                    Object var5_10 = null;
                    try (BufferedReader r = Files.newBufferedReader(mavenCoreJar.resolve(MAVEN_CORE_POM_PROPERTIES));){
                        pomProperties.load(r);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
            }
            if ((version = pomProperties.getProperty("version")) == null) return Messages.MavenEmbeddedRuntime_unknown;
            mavenVersion = version;
            return mavenVersion;
        }
        catch (Exception e) {
            log.warn("Could not determine embedded maven version", (Throwable)e);
        }
        return Messages.MavenEmbeddedRuntime_unknown;
    }
}

