/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class ArgumentUtils {
    private static final String DATA_PROPERTY = "data";
    private static final String SOURCE_PROPERTY = "source";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String CODE_PROPERTY = "code";
    private static final String RANGE_PROPERTY = "range";
    private static final String DIAGNOSTICS_PROPERTY = "diagnostics";
    private static final String END_PROPERTY = "end";
    private static final String START_PROPERTY = "start";
    private static final String CHARACTER_PROPERTY = "character";
    private static final String LINE_PROPERTY = "line";
    private static final String URI_PROPERTY = "uri";

    public static Map<String, Object> getFirst(List<Object> arguments) {
        return arguments.isEmpty() ? null : (Map)arguments.get(0);
    }

    public static String getString(Map<String, Object> obj, String key) {
        return (String)obj.get(key);
    }

    public static List<String> getStringList(Map<String, Object> obj, String key) {
        return (List)obj.get(key);
    }

    public static boolean getBoolean(Map<String, Object> obj, String key) {
        Object result = obj.get(key);
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    public static int getInt(Map<String, Object> obj, String key) {
        Object result = obj.get(key);
        return result != null && result instanceof Number ? ((Number)result).intValue() : 0;
    }

    public static TextDocumentIdentifier getTextDocumentIdentifier(Map<String, Object> obj, String key) {
        Map textDocumentIdentifierObj = (Map)obj.get(key);
        if (textDocumentIdentifierObj == null) {
            return null;
        }
        String uri = ArgumentUtils.getString(textDocumentIdentifierObj, URI_PROPERTY);
        return new TextDocumentIdentifier(uri);
    }

    public static Position getPosition(Map<String, Object> obj, String key) {
        Map positionObj = (Map)obj.get(key);
        if (positionObj == null) {
            return null;
        }
        int line = ArgumentUtils.getInt(positionObj, LINE_PROPERTY);
        int character = ArgumentUtils.getInt(positionObj, CHARACTER_PROPERTY);
        return new Position(line, character);
    }

    public static Range getRange(Map<String, Object> obj, String key) {
        Map rangeObj = (Map)obj.get(key);
        if (rangeObj == null) {
            return null;
        }
        Position start = ArgumentUtils.getPosition(rangeObj, START_PROPERTY);
        Position end = ArgumentUtils.getPosition(rangeObj, END_PROPERTY);
        return new Range(start, end);
    }

    public static CodeActionContext getCodeActionContext(Map<String, Object> obj, String key) {
        Map contextObj = (Map)obj.get(key);
        if (contextObj == null) {
            return null;
        }
        List diagnosticsObj = (List)contextObj.get(DIAGNOSTICS_PROPERTY);
        List diagnostics = diagnosticsObj.stream().map(diagnosticObj -> {
            Diagnostic diagnostic = new Diagnostic();
            diagnostic.setRange(ArgumentUtils.getRange(diagnosticObj, RANGE_PROPERTY));
            diagnostic.setCode(ArgumentUtils.getString(diagnosticObj, CODE_PROPERTY));
            diagnostic.setMessage(ArgumentUtils.getString(diagnosticObj, MESSAGE_PROPERTY));
            diagnostic.setSource(ArgumentUtils.getString(diagnosticObj, SOURCE_PROPERTY));
            diagnostic.setData((Object)ArgumentUtils.getObjectAsJson(diagnosticObj, DATA_PROPERTY));
            return diagnostic;
        }).collect(Collectors.toList());
        List only = null;
        return new CodeActionContext(diagnostics, only);
    }

    public static Map<String, Object> getObject(Map<String, Object> obj, String key) {
        Object child = obj.get(key);
        if (child != null && child instanceof Map) {
            return (Map)child;
        }
        return null;
    }

    public static JsonObject getObjectAsJson(Map<String, Object> obj, String key) {
        Object child = obj.get(key);
        if (child != null && child instanceof Map) {
            Gson gson = new Gson();
            return (JsonObject)gson.toJsonTree(obj);
        }
        return null;
    }
}

