/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.utils;

import java.util.Arrays;
import org.eclipse.lsp4mp.jdt.core.utils.YamlUtils;
import org.junit.Assert;
import org.junit.Test;
import org.yaml.snakeyaml.Yaml;

public class YamlUtilsTest {
    @Test
    public void testGetValueNull() {
        Assert.assertNull((Object)YamlUtils.getValueRecursively(Arrays.asList("a", "b", "c"), null));
    }

    @Test
    public void testGetValueOneLevel() {
        Object map = this.makeYamlMap("a: aaa\n");
        String value = YamlUtils.getValueRecursively(Arrays.asList("a"), (Object)map);
        Assert.assertEquals((Object)"aaa", (Object)value);
    }

    @Test
    public void testGetValueMultiLevel() {
        Object map = this.makeYamlMap("a:\n  b:\n    c: hello\n");
        String value = YamlUtils.getValueRecursively(Arrays.asList("a", "b", "c"), (Object)map);
        Assert.assertEquals((Object)"hello", (Object)value);
    }

    @Test
    public void testGetValueMultiLevelFailure() {
        Object map = this.makeYamlMap("a:\n  b:\n    d: hello\n");
        String value = YamlUtils.getValueRecursively(Arrays.asList("a", "b", "c"), (Object)map);
        Assert.assertNull((Object)value);
    }

    @Test
    public void testGetValueMultiEntries() {
        Object map = this.makeYamlMap("a:\n  b:\n    c: hello\n  d:\n    e: hi\n    f: salu\n");
        String value = YamlUtils.getValueRecursively(Arrays.asList("a", "d", "f"), (Object)map);
        Assert.assertEquals((Object)"salu", (Object)value);
        value = YamlUtils.getValueRecursively(Arrays.asList("a", "d", "e"), (Object)map);
        Assert.assertEquals((Object)"hi", (Object)value);
    }

    @Test
    public void testGetValueHandlesNonStrings() {
        Object map = this.makeYamlMap("a:\n  b:\n    c: 50\n");
        String value = YamlUtils.getValueRecursively(Arrays.asList("a", "b", "c"), (Object)map);
        Assert.assertEquals((Object)"50", (Object)value);
    }

    private Object makeYamlMap(String yaml) {
        return new Yaml().load(yaml);
    }
}

