/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ConfigurationMetadata;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.internal.core.PropertiesCollector;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesCollectorTest {
    @Test
    public void merge() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge);
        Assert.assertEquals((long)3L, (long)configuration.getProperties().size());
    }

    @Test
    public void mergeWithOnlySources() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.ONLY_SOURCES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge);
        Assert.assertEquals((long)1L, (long)configuration.getProperties().size());
    }

    @Test
    public void mergeWithReplace() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge, IPropertiesCollector.MergingStrategy.REPLACE);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge, IPropertiesCollector.MergingStrategy.REPLACE);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNotNull((Object)((ItemMetadata)configuration.getProperties().get(1)).getDescription());
    }

    @Test
    public void mergeWithIgnore() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
    }

    private static ConfigurationMetadata createToMerge() {
        ConfigurationMetadata toMerge = new ConfigurationMetadata();
        toMerge.setProperties(new ArrayList());
        ItemMetadata binary = new ItemMetadata();
        binary.setName("binaryProperty");
        toMerge.getProperties().add(binary);
        ItemMetadata source = new ItemMetadata();
        source.setSource(Boolean.valueOf(true));
        toMerge.getProperties().add(source);
        return toMerge;
    }

    private static ConfigurationMetadata createDuplicateMerge() {
        ConfigurationMetadata dupMerge = new ConfigurationMetadata();
        dupMerge.setProperties(new ArrayList());
        ItemMetadata binary2 = new ItemMetadata();
        binary2.setName("binaryProperty");
        binary2.setDescription("binary property with description");
        dupMerge.getProperties().add(binary2);
        return dupMerge;
    }
}

