/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.providers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.IProjectLabelProvider;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;

public class GradleProjectLabelProvider
implements IProjectLabelProvider {
    public static final String GRADLE_LABEL = "gradle";
    private static final String GRADLE_NATURE_ID = "org.eclipse.buildship.core.gradleprojectnature";

    @Override
    public List<String> getProjectLabels(IJavaProject project) throws JavaModelException {
        if (GradleProjectLabelProvider.isGradleProject(project.getProject())) {
            return Collections.singletonList(GRADLE_LABEL);
        }
        return Collections.emptyList();
    }

    private static boolean isGradleProject(IProject project) {
        return JDTMicroProfileUtils.hasNature(project, GRADLE_NATURE_ID);
    }
}

