/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.lsp4mp.jdt.internal.core.project.IConfigSource;

public abstract class AbstractConfigSource<T>
implements IConfigSource {
    private static final Logger LOGGER = Logger.getLogger(AbstractConfigSource.class.getName());
    private final String configFileName;
    private final IJavaProject javaProject;
    private Path configFile;
    private FileTime lastModified;
    private T config;

    public AbstractConfigSource(String configFileName, IJavaProject javaProject) {
        this.configFileName = configFileName;
        this.javaProject = javaProject;
    }

    private Path getConfigFile() {
        if (this.configFile != null && Files.exists(this.configFile, new LinkOption[0])) {
            return this.configFile;
        }
        if (this.javaProject.getProject() != null && this.javaProject.getProject().isAccessible()) {
            try {
                List outputs = Stream.of(((JavaProject)this.javaProject).getResolvedClasspath(true)).filter(entry -> !entry.isTest()).filter(entry -> entry.getEntryKind() == 3).map(entry -> entry.getOutputLocation()).filter(output -> output != null).distinct().collect(Collectors.toList());
                for (IPath output2 : outputs) {
                    File file = this.javaProject.getProject().getLocation().append(output2.removeFirstSegments(1)).append(this.configFileName).toFile();
                    if (!file.exists()) continue;
                    this.configFile = file.toPath();
                    return this.configFile;
                }
                return null;
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while getting configuration", e);
                return null;
            }
        }
        return null;
    }

    private T getConfig() {
        block14: {
            Path configFile = this.getConfigFile();
            if (configFile == null) {
                this.reset();
                return null;
            }
            try {
                FileTime currentLastModified = Files.getLastModifiedTime(configFile, new LinkOption[0]);
                if (currentLastModified.equals(this.lastModified)) break block14;
                this.reset();
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileInputStream input = new FileInputStream(configFile.toFile());){
                        this.config = this.loadConfig(input);
                        this.lastModified = Files.getLastModifiedTime(configFile, new LinkOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.reset();
                    LOGGER.log(Level.SEVERE, "Error while loading properties from '" + configFile + "'.", e);
                }
            }
            catch (IOException e1) {
                LOGGER.log(Level.SEVERE, "Error while getting last modified time for '" + configFile + "'.", e1);
            }
        }
        return this.config;
    }

    @Override
    public final String getProperty(String key) {
        T config = this.getConfig();
        if (config == null) {
            return null;
        }
        return this.getProperty(key, config);
    }

    @Override
    public Integer getPropertyAsInt(String key) {
        String property = this.getProperty(key);
        if (property != null && !property.trim().isEmpty()) {
            try {
                return Integer.parseInt(property.trim());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.SEVERE, "Error while converting '" + property.trim() + "' as Integer for key '" + key + "'", e);
                return null;
            }
        }
        return null;
    }

    private void reset() {
        this.config = null;
    }

    protected abstract T loadConfig(InputStream var1) throws IOException;

    protected abstract String getProperty(String var1, T var2);
}

