/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.lsp4jakarta.jdt.core.JobHelpers;

public class BaseJakartaTest {
    protected static IJavaProject loadJavaProject(String projectName, String parentDirName) throws CoreException, Exception {
        File projectFolder = BaseJakartaTest.copyProjectToWorkingDirectory(projectName, parentDirName);
        Path path = new Path(new File(projectFolder, "/.project").getAbsolutePath());
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, null);
            project.open(null);
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.done();
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            JavaCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor);
            BaseJakartaTest.waitForBackgroundJobs((IProgressMonitor)monitor);
        }
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(description.getName());
        return javaProject;
    }

    private static File copyProjectToWorkingDirectory(String projectName, String parentDirName) throws IOException {
        File from = new File("projects/" + parentDirName + "/" + projectName);
        File to = new File(BaseJakartaTest.getWorkingProjectDirectory(), Paths.get(parentDirName, projectName).toString());
        if (to.exists()) {
            FileUtils.forceDelete((File)to);
        }
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        return to;
    }

    public static File getWorkingProjectDirectory() throws IOException {
        File dir = new File("target", "workingProjects");
        FileUtils.forceMkdir((File)dir);
        return dir;
    }

    private static void waitForBackgroundJobs(IProgressMonitor monitor) throws Exception {
        JobHelpers.waitForJobsToComplete(monitor);
    }
}

