/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.servlet;

import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class FilterDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-servlet";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IAnnotation[] allAnnotations = type.getAnnotations();
                    IAnnotation webFilterAnnotation = null;
                    IAnnotation[] iAnnotationArray = allAnnotations;
                    int n3 = allAnnotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        if (FilterDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.servlet.annotation.WebFilter")) {
                            webFilterAnnotation = annotation;
                        }
                        ++n4;
                    }
                    String[] interfaces = new String[]{"jakarta.servlet.Filter"};
                    boolean isFilterImplemented = FilterDiagnosticsCollector.doesImplementInterfaces(type, interfaces);
                    if (webFilterAnnotation != null && !isFilterImplemented) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Annotated classes with @WebFilter must implement the Filter interface.", "ImplementFilter", null, DiagnosticSeverity.Error));
                    }
                    if (webFilterAnnotation != null) {
                        IMemberValuePair[] memberValues = webFilterAnnotation.getMemberValuePairs();
                        boolean isUrlpatternSpecified = false;
                        boolean isServletNamesSpecified = false;
                        boolean isValueSpecified = false;
                        IMemberValuePair[] iMemberValuePairArray = memberValues;
                        int n5 = memberValues.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMemberValuePair mv = iMemberValuePairArray[n6];
                            if (mv.getMemberName().equals("urlPatterns")) {
                                isUrlpatternSpecified = true;
                            } else if (mv.getMemberName().equals("servletNames")) {
                                isServletNamesSpecified = true;
                            } else if (mv.getMemberName().equals("value")) {
                                isValueSpecified = true;
                            }
                            ++n6;
                        }
                        if (!(isUrlpatternSpecified || isValueSpecified || isServletNamesSpecified)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)webFilterAnnotation, unit, "The annotation @WebFilter must define the attribute 'urlPatterns', 'servletNames' or 'value'.", "CompleteWebFilterAttributes", null, DiagnosticSeverity.Error));
                        }
                        if (isUrlpatternSpecified && isValueSpecified) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)webFilterAnnotation, unit, "The annotation @WebFilter can not have both 'value' and 'urlPatterns' attributes specified at once.", "InvalidWebFilterAttribute", null, DiagnosticSeverity.Error));
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }
}

