/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.JsonRpcHelpers;
import org.eclipse.lsp4jakarta.jdt.core.ProjectUtils;
import org.eclipse.lsp4jakarta.jdt.core.ResourceUtils;

public class JDTUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String PERIOD = ".";
    public static final String SRC = "src";
    public static final String FILE_UNC_PREFIX = "file:////";
    private static final String JDT_SCHEME = "jdt";
    private static Set<String> SILENCED_CODEGENS = Collections.singleton("lombok");
    public static final String DEFAULT_PROJECT_NAME = "jdt.java-project";
    private static final int COMPILATION_UNIT_UPDATE_TIMEOUT = 3000;
    private static final String LEVEL1_URI_REGEX = "(?:\\/(?:(?:\\{(\\w|-|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+\\})|(?:(\\w|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+)))*\\/?";

    public static ICompilationUnit resolveCompilationUnit(String uriString) {
        return JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uriString));
    }

    public static ICompilationUnit resolveCompilationUnit(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFile resource = (IFile)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
        if (resource != null) {
            String name;
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            if (resource.getFileExtension() != null && JavaCore.isJavaLikeFileName((String)(name = resource.getName()))) {
                ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)resource);
                try {
                    long endTime = System.currentTimeMillis() + 3000L;
                    while (!unit.isConsistent() && System.currentTimeMillis() < endTime) {
                    }
                }
                catch (JavaModelException javaModelException) {}
                return unit;
            }
            return null;
        }
        return JDTUtils.getFakeCompilationUnit(uri, (IProgressMonitor)new NullProgressMonitor());
    }

    static ICompilationUnit getFakeCompilationUnit(URI uri, IProgressMonitor monitor) {
        if (uri == null || !"file".equals(uri.getScheme()) || !uri.getPath().endsWith(".java")) {
            return null;
        }
        java.nio.file.Path path = Paths.get(uri);
        if (!Files.isReadable(path)) {
            return null;
        }
        IProject project = JDTUtils.getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String packageName = JDTUtils.getPackageName(javaProject, uri);
        String fileName = path.getName(path.getNameCount() - 1).toString();
        String packagePath = packageName.replace(PERIOD, PATH_SEPARATOR);
        IPath filePath = new Path(SRC).append(packagePath).append(fileName);
        IFile file = project.getFile(filePath);
        if (!file.isLinked()) {
            try {
                JDTUtils.createFolders(file.getParent(), monitor);
                file.createLink(uri, 256, monitor);
            }
            catch (CoreException e) {
                String errMsg = "Failed to create linked resource from " + uri + " to " + project.getName();
                JakartaCorePlugin.logException(errMsg, e);
            }
        }
        if (file.isLinked()) {
            return (ICompilationUnit)JavaCore.create((IResource)file, (IJavaProject)javaProject);
        }
        return null;
    }

    public static void createFolders(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists() && folder instanceof IFolder) {
            IContainer parent = folder.getParent();
            JDTUtils.createFolders(parent, monitor);
            folder.refreshLocal(0, monitor);
            if (!folder.exists()) {
                ((IFolder)folder).create(true, true, monitor);
            }
        }
    }

    public static String getPackageName(IJavaProject javaProject, URI uri) {
        block4: {
            try {
                File file = ResourceUtils.toFile(uri);
                String content = com.google.common.io.Files.toString((File)file, (Charset)Charsets.UTF_8);
                if (content.isEmpty() && javaProject != null && DEFAULT_PROJECT_NAME.equals(javaProject.getProject().getName())) {
                    java.nio.file.Path path;
                    java.nio.file.Path parent = path = Paths.get(uri);
                    while (parent.getParent() != null && parent.getParent().getNameCount() > 0) {
                        String pathStr;
                        String name = (parent = parent.getParent()).getName(parent.getNameCount() - 1).toString();
                        if (!SRC.equals(name) || (pathStr = path.getParent().toString()).length() <= parent.toString().length()) continue;
                        pathStr = pathStr.substring(parent.toString().length() + 1);
                        pathStr = pathStr.replace(PATH_SEPARATOR, PERIOD);
                        return pathStr;
                    }
                    break block4;
                }
                return JDTUtils.getPackageName(javaProject, content);
            }
            catch (IOException e) {
                JakartaCorePlugin.logException("Failed to read package name from " + uri, e);
            }
        }
        return "";
    }

    public static String getPackageName(IJavaProject javaProject, String fileContent) {
        if (fileContent == null) {
            return "";
        }
        char[] source = fileContent.toCharArray();
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setProject(javaProject);
        parser.setIgnoreMethodBodies(true);
        parser.setSource(source);
        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
        PackageDeclaration pkg = ast.getPackage();
        return pkg == null || pkg.getName() == null ? "" : pkg.getName().getFullyQualifiedName();
    }

    public static IClassFile resolveClassFile(String uriString) {
        return JDTUtils.resolveClassFile(JDTUtils.toURI(uriString));
    }

    public static IClassFile resolveClassFile(URI uri) {
        if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
            String handleId = uri.getQuery();
            IJavaElement element = JavaCore.create((String)handleId);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            return cf;
        }
        return null;
    }

    public static IProject getDefaultProject() {
        return JDTUtils.getWorkspaceRoot().getProject(DEFAULT_PROJECT_NAME);
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IFile findFile(String uriString) {
        return (IFile)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
    }

    public static IResource findResource(URI uri, Function<URI, IResource[]> resourceFinder) {
        String uriString;
        int index;
        URI realUri;
        if (uri == null || !"file".equals(uri.getScheme())) {
            return null;
        }
        IResource[] resources = resourceFinder.apply(uri);
        if (resources.length == 0 && !uri.equals(realUri = FileUtil.realURI((URI)uri))) {
            uri = realUri;
            resources = resourceFinder.apply(uri);
        }
        if (resources.length == 0 && "win32".equals(Platform.getOS()) && uri.toString().startsWith(FILE_UNC_PREFIX) && (index = (uriString = uri.toString()).indexOf(PATH_SEPARATOR, FILE_UNC_PREFIX.length())) > 0) {
            String server = uriString.substring(FILE_UNC_PREFIX.length(), index);
            uriString = uriString.replace(server, server.toUpperCase());
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException uRISyntaxException) {}
            resources = resourceFinder.apply(uri);
        }
        switch (resources.length) {
            case 0: {
                return null;
            }
            case 1: {
                return resources[0];
            }
        }
        IResource resource = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource f = iResourceArray[n2];
            if (resource == null || f.getProjectRelativePath().segmentCount() < resource.getProjectRelativePath().segmentCount()) {
                resource = f;
            }
            ++n2;
        }
        return resource;
    }

    public static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            JakartaCorePlugin.logException("Failed to resolve " + uriString, e);
            return null;
        }
    }

    public static String toUri(IClassFile classFile) {
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        String uriString = null;
        try {
            uriString = new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            JakartaCorePlugin.logException("Error generating URI for class ", e);
        }
        return uriString;
    }

    public static String toUri(ITypeRoot typeRoot) {
        if (typeRoot instanceof ICompilationUnit) {
            return JDTUtils.toURI((ICompilationUnit)typeRoot);
        }
        if (typeRoot instanceof IClassFile) {
            return JDTUtils.toUri((IClassFile)typeRoot);
        }
        return null;
    }

    public static Range toRange(IOpenable openable, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            IBuffer buffer = openable.getBuffer();
            if (buffer != null) {
                loc = JsonRpcHelpers.toLine(buffer, offset);
                endLoc = JsonRpcHelpers.toLine(buffer, offset + length);
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            JDTUtils.setPosition(range.getStart(), loc);
            JDTUtils.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    public static Range newRange() {
        return new Range(new Position(), new Position());
    }

    private static void setPosition(Position position, int[] coords) {
        assert (coords.length == 2);
        position.setLine(coords[0]);
        position.setCharacter(coords[1]);
    }

    public static String toURI(ICompilationUnit cu) {
        return JDTUtils.getFileURI(cu.getResource());
    }

    public static String getFileURI(IResource resource) {
        return ResourceUtils.fixURI(resource.getRawLocationURI() == null ? resource.getLocationURI() : resource.getRawLocationURI());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHiddenGeneratedElement(IJavaElement element) {
        if (!(element instanceof IAnnotatable)) return false;
        try {
            IAnnotation[] annotations = ((IAnnotatable)element).getAnnotations();
            if (annotations.length == 0) return false;
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (JDTUtils.isSilencedGeneratedAnnotation(annotation)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private static boolean isSilencedGeneratedAnnotation(IAnnotation annotation) throws JavaModelException {
        if ("javax.annotation.Generated".equals(annotation.getElementName()) || "javax.annotation.processing.Generated".equals(annotation.getElementName())) {
            IMemberValuePair[] memberValuePairs;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair m = iMemberValuePairArray[n2];
                if ("value".equals(m.getMemberName()) && 9 == m.getValueKind()) {
                    if (m.getValue() instanceof String) {
                        return SILENCED_CODEGENS.contains(m.getValue());
                    }
                    if (m.getValue() instanceof Object[]) {
                        Object[] objectArray = (Object[])m.getValue();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object val = objectArray[n4];
                            if (SILENCED_CODEGENS.contains(val)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static Location toLocation(IJavaElement element) throws JavaModelException {
        return JDTUtils.toLocation(element, LocationType.NAME_RANGE);
    }

    public static Location toLocation(IJavaElement element, LocationType type) throws JavaModelException {
        ISourceRange nameRange;
        ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (unit == null && cf == null) {
            return null;
        }
        if (element instanceof ISourceReference && SourceRange.isAvailable((ISourceRange)(nameRange = type.getRange(element)))) {
            if (cf == null) {
                return JDTUtils.toLocation(unit, nameRange.getOffset(), nameRange.getLength());
            }
            return JDTUtils.toLocation(cf, nameRange.getOffset(), nameRange.getLength());
        }
        return null;
    }

    public static ISourceRange getNameRange(IJavaElement element) throws JavaModelException {
        ISourceRange nameRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            nameRange = member.getNameRange();
            if (!SourceRange.isAvailable((ISourceRange)nameRange)) {
                nameRange = member.getSourceRange();
            }
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            nameRange = ((ISourceReference)element).getNameRange();
        } else if (element instanceof ISourceReference) {
            nameRange = ((ISourceReference)element).getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)nameRange) && element.getParent() != null) {
            nameRange = JDTUtils.getNameRange(element.getParent());
        }
        return nameRange;
    }

    private static ISourceRange getSourceRange(IJavaElement element) throws JavaModelException {
        ISourceRange sourceRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            sourceRange = member.getSourceRange();
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            sourceRange = ((ISourceReference)element).getSourceRange();
        } else if (element instanceof ISourceReference) {
            sourceRange = ((ISourceReference)element).getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)sourceRange) && element.getParent() != null) {
            sourceRange = JDTUtils.getSourceRange(element.getParent());
        }
        return sourceRange;
    }

    public static Location toLocation(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        return new Location(ResourceUtils.toClientUri(JDTUtils.toURI(unit)), JDTUtils.toRange((IOpenable)unit, offset, length));
    }

    public static Location toLocation(IClassFile classFile) throws JavaModelException {
        return JDTUtils.toLocation(classFile, 0, 0);
    }

    public static Location toLocation(IClassFile classFile, int offset, int length) throws JavaModelException {
        String uriString = JDTUtils.toUri(classFile);
        if (uriString != null) {
            Range range = JDTUtils.toRange((IOpenable)classFile, offset, length);
            return new Location(uriString, range);
        }
        return null;
    }

    public static boolean hasLeadingSlash(String uriString) {
        return uriString.startsWith(PATH_SEPARATOR);
    }

    public static boolean isValidLevel1URI(String uriString) {
        return uriString.matches(LEVEL1_URI_REGEX);
    }

    public static List<IMethod> getFieldAccessors(ICompilationUnit unit, IField field) throws JavaModelException {
        ArrayList<IMethod> accessors = new ArrayList<IMethod>();
        String fieldName = field.getElementName();
        fieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
        ArrayList<String> accessorNames = new ArrayList<String>();
        accessorNames.add("get" + fieldName);
        accessorNames.add("set" + fieldName);
        accessorNames.add("is" + fieldName);
        IType[] iTypeArray = unit.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                String methodName = method.getElementName();
                if (accessorNames.contains(methodName)) {
                    accessors.add(method);
                }
                ++n4;
            }
            ++n2;
        }
        return accessors;
    }

    public static void waitForLifecycleJobs(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
    }

    public static int toOffset(IBuffer buffer, int line, int column) {
        return JsonRpcHelpers.toOffset(buffer, line, column);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LocationType {
        NAME_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getNameRange(element);
            }
        }
        ,
        FULL_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getSourceRange(element);
            }
        };


        abstract ISourceRange getRange(IJavaElement var1) throws JavaModelException;
    }
}

