/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ReplaceAnnotationProposal;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix.InsertAnnotationMissingQuickFix;
import org.eclipse.lsp4jakarta.jdt.core.cdi.ManagedBeanConstants;

public class ManagedBeanQuickFix
extends InsertAnnotationMissingQuickFix {
    private static final String[] REMOVE_ANNOTATION_NAMES = new ArrayList<String>(ManagedBeanConstants.SCOPES).toArray(new String[ManagedBeanConstants.SCOPES.size()]);

    public ManagedBeanQuickFix() {
        super("jakarta.enterprise.context.Dependent");
    }

    @Override
    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        String[] annotations;
        String[] stringArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            ManagedBeanQuickFix.insertAndReplaceAnnotation(diagnostic, context, parentType, codeActions, annotation);
            ++n2;
        }
    }

    private static void insertAndReplaceAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String annotation) throws CoreException {
        ASTNode parentNode = context.getASTRoot().findDeclaringNode(parentType);
        IBinding classBinding = ManagedBeanQuickFix.getBinding(parentNode);
        String name = ManagedBeanQuickFix.getLabel(annotation);
        ReplaceAnnotationProposal proposal = new ReplaceAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), classBinding, 0, annotation, REMOVE_ANNOTATION_NAMES);
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    private static String getLabel(String annotation) {
        StringBuilder name = new StringBuilder("Replace current scope with ");
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        name.append("@");
        name.append(annotationName);
        return name.toString();
    }
}

