/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.AddConstructorProposal;

public class ManagedBeanNoArgConstructorQuickFix
implements IJavaCodeActionParticipant {
    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        IBinding parentType = ManagedBeanNoArgConstructorQuickFix.getBinding(node);
        if (parentType != null) {
            ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
            codeActions.addAll(this.addConstructor(diagnostic, context, parentType));
            return codeActions;
        }
        return null;
    }

    protected static IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)node.getParent();
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    private List<CodeAction> addConstructor(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        String name = "Add a no-arg protected constructor to this class";
        AddConstructorProposal proposal = new AddConstructorProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0);
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
        name = "Add a no-arg public constructor to this class";
        proposal = new AddConstructorProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, "public");
        codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
        return codeActions;
    }
}

