/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.format;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormatHandlerReadOnlyTest
extends AbstractTestWithProject {
    @Test
    public void testFormatOnReadOnlyFileAndMakeWritable() throws Exception {
        List<TextEdit> edits = List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "//"), new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "//"));
        MockLanguageServer.INSTANCE.setFormattingTextEdits(edits);
        String content = "line1\nline2\n";
        IFile file = TestUtils.createUniqueTestFile(this.project, content);
        ResourceAttributes attrs = file.getResourceAttributes();
        attrs.setReadOnly(true);
        file.setResourceAttributes(attrs);
        Assertions.assertTrue((boolean)file.getResourceAttributes().isReadOnly());
        IEditorPart editor = TestUtils.openEditor(file);
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(0, doc.getLength()));
        final Display display = Display.getDefault();
        final HashSet<Shell> beforeShells = new HashSet<Shell>(Arrays.asList(display.getShells()));
        final AtomicBoolean dialogShown = new AtomicBoolean(false);
        display.asyncExec(new Runnable(){

            Button findYesButton(Composite parent) {
                Control[] controlArray = parent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Composite composite;
                    Button result;
                    Button button;
                    Control child = controlArray[n2];
                    if (child instanceof Button && (button = (Button)child).getText().toLowerCase().contains("yes")) {
                        return button;
                    }
                    if (child instanceof Composite && (result = this.findYesButton(composite = (Composite)child)) != null) {
                        return result;
                    }
                    ++n2;
                }
                return null;
            }

            @Override
            public void run() {
                Shell newShell = TestUtils.findNewShell(beforeShells, display);
                if (newShell == null || !Messages.LSPFormatHandler_ReadOnlyEditor_title.equals(newShell.getText())) {
                    display.timerExec(50, (Runnable)this);
                    return;
                }
                dialogShown.set(true);
                Button yes = this.findYesButton((Composite)newShell);
                if (yes != null) {
                    yes.notifyListeners(13, new Event());
                }
            }
        });
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.executeCommand("org.eclipse.lsp4e.format", null);
        TestUtils.waitForAndAssertCondition(5000, dialogShown::get);
        TestUtils.waitForAndAssertCondition(5000, () -> !file.getResourceAttributes().isReadOnly());
        TestUtils.waitForAndAssertCondition(5000, () -> "//line1\n//line2\n".equals(doc.get()));
    }
}

