/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.SymbolInformation;

public class SymbolInformationPropertyTester
extends PropertyTester {
    public static final String FILE_EXTENSION = "extension";
    public static final String CONTENT_TYPE_ID = "contentTypeId";

    public boolean test(@Nullable Object receiver, String property, Object[] args, @Nullable Object expectedValue) {
        block12: {
            if (!(receiver instanceof SymbolInformation)) break block12;
            SymbolInformation info = (SymbolInformation)receiver;
            if (info.getLocation() == null || info.getLocation().getUri() == null) {
                return false;
            }
            String uri = info.getLocation().getUri();
            return switch (property) {
                case FILE_EXTENSION -> uri.endsWith("." + String.valueOf(expectedValue));
                case CONTENT_TYPE_ID -> {
                    IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                    IContentType contentType = contentTypeManager.findContentTypeFor(uri);
                    if (contentType != null && expectedValue != null && contentType.getId().equals(expectedValue.toString())) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }
}

