/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;

public class MockWorkspaceService
implements WorkspaceService {
    private Function<?, ?> _futureFactory;
    private CompletableFuture<ExecuteCommandParams> executedCommand = new CompletableFuture();
    private List<DidChangeWorkspaceFoldersParams> workspaceFoldersEvents = new ArrayList<DidChangeWorkspaceFoldersParams>();
    private List<DidChangeWatchedFilesParams> watchedFilesEvents = new ArrayList<DidChangeWatchedFilesParams>();

    public <U> MockWorkspaceService(Function<U, CompletableFuture<U>> futureFactory) {
        this._futureFactory = futureFactory;
    }

    private <U> CompletableFuture<U> futureFactory(U value) {
        return (CompletableFuture)this._futureFactory.apply(value);
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        return null;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.watchedFilesEvents.add(params);
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.workspaceFoldersEvents.add(params);
    }

    public List<DidChangeWorkspaceFoldersParams> getWorkspaceFoldersEvents() {
        return this.workspaceFoldersEvents;
    }

    public List<DidChangeWatchedFilesParams> getWatchedFilesEvents() {
        return this.watchedFilesEvents;
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        this.executedCommand.complete(params);
        return this.futureFactory(null);
    }

    public CompletableFuture<ExecuteCommandParams> getExecutedCommand() {
        return this.executedCommand;
    }
}

