/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.lsp4e.operations.semanticTokens.StyleRangeHolder;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.junit.Assert;
import org.junit.Test;

public class StyleRangeHolderTest
extends AbstractTest {
    private static final Color RED = new Color(255, 0, 0);
    private List<StyleRange> originalStyleRanges = Arrays.asList(new StyleRange(0, 4, RED, null), new StyleRange(15, 4, RED, null), new StyleRange(24, 7, RED, null));

    @Test
    public void testAllDocumentRanges() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        StyleRange[] allDocumentRanges = holder.overlappingRanges((IRegion)new Region(0, 50));
        Assert.assertNotEquals(this.originalStyleRanges, (Object)allDocumentRanges);
        Assert.assertEquals((long)this.originalStyleRanges.size(), (long)allDocumentRanges.length);
    }

    @Test
    public void testPartialDocumentRanges() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        StyleRange[] allDocumentRanges = holder.overlappingRanges((IRegion)new Region(0, 20));
        Assert.assertEquals((long)2L, (long)allDocumentRanges.length);
    }

    @Test
    public void testDocumentChange() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        TextEvent textEvent = new TextEvent(0, 1, " ", null, new DocumentEvent(), false){};
        holder.textChanged(textEvent);
        StyleRange[] noOverlappingRanges = holder.overlappingRanges((IRegion)new Region(0, 10));
        Assert.assertEquals((long)0L, (long)noOverlappingRanges.length);
        StyleRange[] twoShiftedOverlappingRanges = holder.overlappingRanges((IRegion)new Region(10, 50));
        Assert.assertEquals((long)2L, (long)twoShiftedOverlappingRanges.length);
        Assert.assertEquals((long)16L, (long)twoShiftedOverlappingRanges[0].start);
        Assert.assertEquals((long)4L, (long)twoShiftedOverlappingRanges[0].length);
        Assert.assertEquals((long)25L, (long)twoShiftedOverlappingRanges[1].start);
        Assert.assertEquals((long)7L, (long)twoShiftedOverlappingRanges[1].length);
    }
}

