/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.StyleUtil;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class SymbolsLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IEclipsePreferences.IPreferenceChangeListener {
    private final Map<IResource, RangeMap<Integer, Integer>> severities = new HashMap<IResource, RangeMap<Integer, Integer>>();
    private final IResourceChangeListener listener = e -> {
        try {
            IResourceDelta delta = e.getDelta();
            if (delta != null) {
                delta.accept(d -> {
                    if (d.getMarkerDeltas().length > 0) {
                        this.severities.remove(d.getResource());
                    }
                    return true;
                });
            }
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    };
    private final Map<Image, Image[]> overlays = new HashMap<Image, Image[]>();
    private final boolean showLocation;
    private boolean showKind;

    public SymbolsLabelProvider() {
        this(false, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
    }

    public SymbolsLabelProvider(boolean showLocation, boolean showKind) {
        this.showLocation = showLocation;
        this.showKind = showKind;
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.overlays.values().stream().flatMap(Arrays::stream).filter(Objects::nonNull).forEach(Resource::dispose);
        this.overlays.clear();
        super.dispose();
    }

    /*
     * Unable to fully structure code
     */
    public Image getImage(Object element) {
        block25: {
            block27: {
                block26: {
                    if (element == null) {
                        return null;
                    }
                    if (element instanceof PendingUpdateAdapter) {
                        return JFaceResources.getImage((String)"WAITING_JOB");
                    }
                    if (element instanceof Throwable) {
                        return LSPImages.getSharedImage("IMG_OBJS_ERROR_TSK");
                    }
                    var3_2 = element;
                    if (var3_2 instanceof Either) {
                        var2_3 = (Either)var3_2;
                        (Either)var3_2;
                        element = either.get();
                    }
                    res = null;
                    var6_5 = element;
                    if (var6_5 instanceof SymbolInformation) {
                        var5_6 = (SymbolInformation)var6_5;
                        (SymbolInformation)var6_5;
                        res = LSPImages.imageFromSymbolKind(info.getKind());
                    } else {
                        var8_7 = element;
                        if (var8_7 instanceof WorkspaceSymbol) {
                            var7_8 = (WorkspaceSymbol)var8_7;
                            (WorkspaceSymbol)var8_7;
                            res = LSPImages.imageFromSymbolKind(symbol.getKind());
                        } else {
                            var10_9 = element;
                            if (var10_9 instanceof DocumentSymbol) {
                                var9_10 = (DocumentSymbol)var10_9;
                                (DocumentSymbol)var10_9;
                                res = LSPImages.imageFromSymbolKind(symbol.getKind());
                            } else {
                                var12_11 = element;
                                if (var12_11 instanceof SymbolsModel.DocumentSymbolWithURI) {
                                    var11_12 = (SymbolsModel.DocumentSymbolWithURI)var12_11;
                                    (SymbolsModel.DocumentSymbolWithURI)var12_11;
                                    res = LSPImages.imageFromSymbolKind(symbolWithURI.symbol.getKind());
                                }
                            }
                        }
                    }
                    file = null;
                    var15_14 = element;
                    if (var15_14 instanceof SymbolInformation) {
                        var14_15 = (SymbolInformation)var15_14;
                        (SymbolInformation)var15_14;
                        file = LSPEclipseUtils.findResourceFor(symbol.getLocation().getUri());
                    } else {
                        var17_16 = element;
                        if (var17_16 instanceof WorkspaceSymbol) {
                            var16_17 = (WorkspaceSymbol)var17_16;
                            (WorkspaceSymbol)var17_16;
                            file = LSPEclipseUtils.findResourceFor(SymbolsLabelProvider.getUri((WorkspaceSymbol)symbol));
                        } else {
                            var19_18 = element;
                            if (var19_18 instanceof SymbolsModel.DocumentSymbolWithURI) {
                                var18_19 = (SymbolsModel.DocumentSymbolWithURI)var19_18;
                                (SymbolsModel.DocumentSymbolWithURI)var19_18;
                                file = LSPEclipseUtils.findResourceFor(symbolWithURI.uri);
                            }
                        }
                    }
                    if (file == null) break block25;
                    range = null;
                    var22_21 = element;
                    if (!(var22_21 instanceof SymbolInformation)) break block26;
                    var21_22 = (SymbolInformation)var22_21;
                    (SymbolInformation)var22_21;
                    range = symbol.getLocation().getRange();
                    break block27;
                }
                var24_23 = element;
                if (!(var24_23 instanceof WorkspaceSymbol)) ** GOTO lbl-1000
                var23_24 = (WorkspaceSymbol)var24_23;
                (WorkspaceSymbol)var24_23;
                if (symbol.getLocation().isLeft()) {
                    range = ((Location)symbol.getLocation().getLeft()).getRange();
                } else if ((var26_25 = element) instanceof DocumentSymbol) {
                    var25_26 = (DocumentSymbol)var26_25;
                    (DocumentSymbol)var26_25;
                    range = documentSymbol.getRange();
                } else {
                    var28_27 = element;
                    if (var28_27 instanceof SymbolsModel.DocumentSymbolWithURI) {
                        var27_28 = (SymbolsModel.DocumentSymbolWithURI)var28_27;
                        (SymbolsModel.DocumentSymbolWithURI)var28_27;
                        range = symbolWithURI.symbol.getRange();
                    }
                }
            }
            if (range != null) {
                try {
                    doc = LSPEclipseUtils.getExistingDocument(file);
                    if (doc != null && (maxSeverity = this.getMaxSeverity(file, doc, range)) > 0) {
                        return this.getOverlay(res, maxSeverity);
                    }
                }
                catch (CoreException | BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return res;
    }

    protected int getMaxSeverity(@NonNull IResource resource, @NonNull IDocument doc, @NonNull Range range) throws CoreException, BadLocationException {
        RangeMap<Integer, Integer> severitiesForResource;
        if (!this.severities.containsKey(resource)) {
            this.refreshMarkersByLine(resource);
        }
        if ((severitiesForResource = this.severities.get(resource)) == null) {
            return -1;
        }
        int bound1 = LSPEclipseUtils.toOffset(range.getStart(), doc);
        int bound2 = LSPEclipseUtils.toOffset(range.getEnd(), doc);
        com.google.common.collect.Range subRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(Math.min(bound1, bound2)), (Comparable)Integer.valueOf(bound2));
        return severitiesForResource.subRangeMap(subRange).asMapOfRanges().values().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void refreshMarkersByLine(IResource resource) throws CoreException {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        Arrays.stream(resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).filter(marker -> marker.getAttribute("severity", -1) > 0).sorted(Comparator.comparingInt(marker -> marker.getAttribute("severity", -1))).forEach(arg_0 -> SymbolsLabelProvider.lambda$7((RangeMap)rangeMap, arg_0));
        this.severities.put(resource, (RangeMap<Integer, Integer>)rangeMap);
    }

    private Image getOverlay(Image res, int maxSeverity) {
        if (maxSeverity != 1 && maxSeverity != 2) {
            throw new IllegalArgumentException("Severity " + maxSeverity + " not supported.");
        }
        Image[] currentOverlays = this.overlays.computeIfAbsent(res, key -> new Image[2]);
        if (currentOverlays[maxSeverity - 1] == null) {
            String overlayId = null;
            if (maxSeverity == 2) {
                overlayId = "IMG_DEC_FIELD_ERROR";
            } else if (maxSeverity == 1) {
                overlayId = "IMG_DEC_FIELD_WARNING";
            }
            currentOverlays[maxSeverity - 1] = new DecorationOverlayIcon(res, LSPImages.getSharedImageDescriptor(overlayId), 2).createImage();
        }
        return currentOverlays[maxSeverity - 1];
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return new StyledString(Messages.outline_computingSymbols);
        }
        Object object = element;
        if (object instanceof Throwable) {
            void throwable;
            Throwable throwable2 = (Throwable)object;
            Throwable cfr_ignored_0 = (Throwable)object;
            String message = throwable.getMessage();
            if (message == null) {
                message = element.getClass().getName();
            }
            return new StyledString(message);
        }
        StyledString res = new StyledString();
        if (element == null) {
            return res;
        }
        Object object2 = element;
        if (object2 instanceof Either) {
            void either;
            Either either2 = (Either)object2;
            Either cfr_ignored_1 = (Either)object2;
            element = either.get();
        }
        String name = null;
        SymbolKind kind = null;
        String detail = null;
        URI location = null;
        boolean deprecated = false;
        Object object3 = element;
        if (object3 instanceof SymbolInformation) {
            void symbolInformation;
            SymbolInformation symbolInformation2 = (SymbolInformation)object3;
            SymbolInformation cfr_ignored_2 = (SymbolInformation)object3;
            name = symbolInformation.getName();
            kind = symbolInformation.getKind();
            deprecated = this.isDeprecated(symbolInformation.getTags()) || symbolInformation.getDeprecated() == null ? false : symbolInformation.getDeprecated();
            try {
                location = URI.create(symbolInformation.getLocation().getUri());
            }
            catch (IllegalArgumentException e) {
                LanguageServerPlugin.logError("Invalid URI: " + symbolInformation.getLocation().getUri(), e);
            }
        } else {
            Object object4 = element;
            if (object4 instanceof WorkspaceSymbol) {
                void workspaceSymbol;
                WorkspaceSymbol e = (WorkspaceSymbol)object4;
                WorkspaceSymbol cfr_ignored_3 = (WorkspaceSymbol)object4;
                name = workspaceSymbol.getName();
                kind = workspaceSymbol.getKind();
                String rawUri = SymbolsLabelProvider.getUri((WorkspaceSymbol)workspaceSymbol);
                deprecated = this.isDeprecated(workspaceSymbol.getTags());
                try {
                    location = URI.create(rawUri);
                }
                catch (IllegalArgumentException e2) {
                    LanguageServerPlugin.logError("Invalid URI: " + rawUri, e2);
                }
            } else {
                Object object5 = element;
                if (object5 instanceof DocumentSymbol) {
                    void documentSymbol;
                    DocumentSymbol rawUri = (DocumentSymbol)object5;
                    DocumentSymbol cfr_ignored_4 = (DocumentSymbol)object5;
                    name = documentSymbol.getName();
                    kind = documentSymbol.getKind();
                    detail = documentSymbol.getDetail();
                    deprecated = this.isDeprecated(documentSymbol.getTags()) || documentSymbol.getDeprecated() == null ? false : documentSymbol.getDeprecated();
                } else {
                    Object object6 = element;
                    if (object6 instanceof SymbolsModel.DocumentSymbolWithURI) {
                        void symbolWithURI;
                        SymbolsModel.DocumentSymbolWithURI documentSymbolWithURI = (SymbolsModel.DocumentSymbolWithURI)object6;
                        SymbolsModel.DocumentSymbolWithURI cfr_ignored_5 = (SymbolsModel.DocumentSymbolWithURI)object6;
                        name = symbolWithURI.symbol.getName();
                        kind = symbolWithURI.symbol.getKind();
                        detail = symbolWithURI.symbol.getDetail();
                        location = symbolWithURI.uri;
                        boolean bl = deprecated = this.isDeprecated(symbolWithURI.symbol.getTags()) || symbolWithURI.symbol.getDeprecated() == null ? false : symbolWithURI.symbol.getDeprecated();
                    }
                }
            }
        }
        if (name != null) {
            if (deprecated) {
                res.append(name, StyleUtil.DEPRECATE);
            } else {
                res.append(name, null);
            }
        }
        if (detail != null) {
            res.append(' ');
            res.append(detail, StyledString.DECORATIONS_STYLER);
        }
        if (this.showKind && kind != null) {
            res.append(" :", null);
            res.append(kind.toString(), StyledString.DECORATIONS_STYLER);
        }
        if (this.showLocation && location != null) {
            res.append(' ');
            res.append(location.getPath(), StyledString.QUALIFIER_STYLER);
        }
        return res;
    }

    private boolean isDeprecated(List<SymbolTag> tags) {
        if (tags != null) {
            return tags.contains(SymbolTag.Deprecated);
        }
        return false;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    /*
     * WARNING - void declaration
     */
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.lsp4e.outline.showKind")) {
            this.showKind = Boolean.valueOf(event.getNewValue().toString());
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                Object object = listener;
                if (object instanceof ILabelProviderListener) {
                    void labelProviderListener;
                    ILabelProviderListener cfr_ignored_0 = (ILabelProviderListener)object;
                    ILabelProviderListener cfr_ignored_1 = (ILabelProviderListener)object;
                    labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
                }
                ++n2;
            }
        }
    }

    private static String getUri(WorkspaceSymbol symbol) {
        return (String)symbol.getLocation().map(Location::getUri, WorkspaceSymbolLocation::getUri);
    }

    private static /* synthetic */ void lambda$7(RangeMap rangeMap, IMarker marker) {
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        if (end < start) {
            end = start;
        }
        int severity = marker.getAttribute("severity", -1);
        if (start != end) {
            com.google.common.collect.Range markerRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end - 1));
            rangeMap.remove(markerRange);
            rangeMap.put(markerRange, (Object)severity);
        }
    }
}

