/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PartInitException;
import org.junit.Assert;
import org.junit.Test;

public class CompleteCompletionTest
extends AbstractCompletionTest {
    @Test
    public void testAssistForUnknownButConnectedType() throws CoreException, IOException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileOfUnknownType(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assert.assertNotNull((Object)serverDefinition);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)testFile.getProject(), (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        URI fileLocation = testFile.getLocationURI();
        lsWrapper.connect(testFile, null);
        TestUtils.waitForAndAssertCondition(3000, () -> lsWrapper.isConnectedTo(fileLocation));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testNoPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        items.add(this.createCompletionItem("SecondClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCommandExecution() throws CoreException, InterruptedException, ExecutionException, TimeoutException {
        CompletionItem completionItem = this.createCompletionItem("Bla", CompletionItemKind.Class);
        String expectedParameter = "command execution parameter";
        List<Object> commandArguments = Arrays.asList(expectedParameter);
        completionItem.setCommand(new Command("TestCommand", MockLanguageServer.SUPPORTED_COMMAND_ID, commandArguments));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Arrays.asList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        ExecuteCommandParams executedCommand = (ExecuteCommandParams)MockLanguageServer.INSTANCE.getWorkspaceService().getExecutedCommand().get(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)MockLanguageServer.SUPPORTED_COMMAND_ID, (Object)executedCommand.getCommand());
        List<JsonPrimitive> expectedParameterList = Arrays.asList(new JsonPrimitive(expectedParameter));
        Assert.assertEquals(expectedParameterList, (Object)executedCommand.getArguments());
    }

    @Test
    public void testPrefixCaseSensitivity() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompleteOnFileEnd() throws CoreException {
        CompletionItem item = new CompletionItem();
        item.setLabel("1024M");
        item.setKind(CompletionItemKind.Value);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(2, 10), new Position(2, 10)), "1024M")));
        CompletionList completionList = new CompletionList(false, Collections.singletonList(item));
        MockLanguageServer.INSTANCE.setCompletionList(completionList);
        String content = "applications:\n- name: hello\n  memory: ";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, content.length());
        Assert.assertEquals((Object)(String.valueOf(content) + "1024M"), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testTriggerCharsWithoutPreliminaryCompletion() throws CoreException {
        HashSet<String> triggers = new HashSet<String>();
        triggers.add("a");
        triggers.add("b");
        MockLanguageServer.INSTANCE.setCompletionTriggerChars(triggers);
        String content = "First";
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        TestUtils.waitForAndAssertCondition(3000, () -> Arrays.equals(new char[]{'a', 'b'}, this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters()));
    }

    @Test
    public void testTriggerCharsNullList() throws CoreException {
        MockLanguageServer.INSTANCE.setCompletionTriggerChars(null);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assert.assertArrayEquals((char[])new char[0], (char[])this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters());
    }

    @Test
    public void testApplyCompletionWithPrefix() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 5));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, content.length());
        Assert.assertEquals((Object)true, (Object)viewer.getDocument().get().equals("FirstClass"));
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplace() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 5);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 5);
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTypingWithTextEdit() throws CoreException, BadLocationException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 5;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(5, 0, "No");
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset + "No".length());
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTyping() throws CoreException, BadLocationException {
        CompletionItem item = new CompletionItem("strncasecmp");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("strncasecmp()");
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(item)));
        String content = "str";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = content.length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(content.length(), 0, "nc");
        lsCompletionProposal.apply(viewer, '\u0000', 0, invokeOffset + "nc".length());
        Assert.assertEquals((Object)item.getInsertText(), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(item.getInsertText().length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionReplace() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(this.createCompletionItem("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length()))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testItemOrdering() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 1));
        List<CompletionItem> items = Arrays.asList(this.createCompletionItem("AA", CompletionItemKind.Class, range), this.createCompletionItem("AB", CompletionItemKind.Class, range), this.createCompletionItem("BA", CompletionItemKind.Class, range), this.createCompletionItem("BB", CompletionItemKind.Class, range), this.createCompletionItem("CB", CompletionItemKind.Class, range), this.createCompletionItem("CC", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "B";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 1;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)4L, (long)proposals.length);
        Assert.assertEquals((Object)"BA", (Object)proposals[0].getDisplayString());
        Assert.assertEquals((Object)"BB", (Object)proposals[1].getDisplayString());
        Assert.assertEquals((Object)"AB", (Object)proposals[2].getDisplayString());
        Assert.assertEquals((Object)"CB", (Object)proposals[3].getDisplayString());
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"BA", (Object)viewer.getDocument().get());
    }

    @Test
    public void testBasicSnippet() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("$1 and ${2:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)" and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testChoiceSnippet() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("1${1|a,b|}2", CompletionItemKind.Class);
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        HashSet<Shell> beforeShells = new HashSet<Shell>(Arrays.asList(viewer.getTextWidget().getDisplay().getShells()));
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"1a2", (Object)viewer.getDocument().get());
        HashSet<Shell> newShells = new HashSet<Shell>(Arrays.asList(viewer.getTextWidget().getDisplay().getShells()));
        newShells.removeAll(beforeShells);
        Assert.assertNotEquals(Collections.emptySet(), newShells);
        Table proposalList = (Table)((Shell)newShells.iterator().next()).getChildren()[0];
        Object[] itemLabels = (String[])Arrays.stream(proposalList.getItems()).map(TableItem::getText).toArray(String[]::new);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])itemLabels);
    }

    @Test
    public void testDuplicateVariable() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:foo} and ${1:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"foo and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testSnippetTabStops() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("sum(${1:x}, ${2:y})", CompletionItemKind.Method, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"sum(x, y)", (Object)viewer.getDocument().get());
        Point range = proposals[0].getSelection(viewer.getDocument());
        Assert.assertEquals((long)4L, (long)range.x);
        Assert.assertEquals((long)1L, (long)range.y);
        Event event = new Event();
        event.character = (char)9;
        viewer.getTextWidget().notifyListeners(3005, event);
        range = viewer.getSelectedRange();
        Assert.assertEquals((long)7L, (long)range.x);
        Assert.assertEquals((long)1L, (long)range.y);
    }

    @Test
    public void testMultipleLS() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)(2L * (long)items.size()), (long)proposals.length);
    }

    @Test
    public void testReopeningFileAndReusingContentAssist() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
        UI.getActivePage().closeAllEditors(false);
        MockLanguageServer.reset();
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        viewer = TestUtils.openTextViewer(testFile);
        proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testFilterNonmatchingCompletions() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("server.web");
        item.setFilterText("server.web");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(0, 0), new Position(0, 10)), item.getFilterText())));
        items.add(item);
        item = new CompletionItem("soup");
        item.setFilterText("soup");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(0, 3), new Position(0, 7)), item.getFilterText())));
        items.add(item);
        items.add(new CompletionItem(": 1.0.1"));
        items.add(new CompletionItem("s.Status"));
        this.confirmCompletionResults(items, "server", (Integer)6, new String[]{"server.web", ": 1.0.1", "s.Status"});
    }

    @Test
    public void testFilterNonmatchingCompletionsMovieOffset() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "servers");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, new CompletionItem(": 1.0.1"), wrapper);
        Assert.assertTrue((boolean)completionProposal.isValidFor(document, 6));
        Assert.assertFalse((boolean)completionProposal.isValidFor(document, 7));
    }

    @Test
    public void testAdjustIndentation() throws Exception {
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "a\n\tb\n\t\nc"));
        CompletionItem item = new CompletionItem("line1\nline2");
        item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        int invokeOffset = 6;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"a\n\tb\n\tline1\n\tline2\nc", (Object)viewer.getDocument().get());
    }
}

