/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.rename;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameHandler;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class RenameTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testRenameHandlerEnablement() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
        editor.selectAndReveal(1, 0);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        Assert.assertTrue((boolean)command.isEnabled());
        Assert.assertTrue((boolean)command.isHandled());
    }

    @Test
    public void testAsyncRenameHandlerEnablement() throws Exception {
        long delay = 2000L;
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(delay);
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
        editor.selectAndReveal(1, 0);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        Assert.assertFalse((command.isEnabled() && command.isHandled() ? 1 : 0) != 0);
        Thread.sleep(delay * 3L);
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(0L);
        Assert.assertTrue((command.isEnabled() && command.isHandled() ? 1 : 0) != 0);
    }

    @Test
    public void testRenameRefactoring() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assert.assertNotNull((Object)document);
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            processor.setNewName("new");
            try {
                ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        })).join();
        Assert.assertEquals((Object)"new", (Object)document.get());
    }

    @Test
    public void testPrepareRenameRefactoring() throws Exception {
        IProject project = TestUtils.createProject("testPrepareRenameRefactoring");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assert.assertNotNull((Object)document);
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            processor.setNewName("new");
            try {
                ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        })).join();
        Assert.assertEquals((Object)"new", (Object)document.get());
    }

    @Test
    public void testPrepareRenameRefactoringError() throws Exception {
        IProject project = TestUtils.createProject("testPrepareRenameRefactoring");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        MockLanguageServer.INSTANCE.getTextDocumentService().setPrepareRenameResult(null);
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assert.assertNotNull((Object)document);
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            processor.setNewName("new");
            try {
                ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                RefactoringStatus status = processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                Assert.assertEquals((long)4L, (long)status.getSeverity());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        })).join();
    }

    @Test
    public void testRenameRefactoringExternalFile() throws Exception {
        File file = TestUtils.createTempFile("testPerformOperationExternalFile", ".lspt");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(file.toURI()));
        IFileStore store = EFS.getStore((URI)file.toURI());
        ITextFileBufferManager manager = ITextFileBufferManager.DEFAULT;
        try {
            manager.connectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
            IDocument document = ((ITextFileBuffer)manager.getFileStoreFileBuffer(store)).getDocument();
            document.set("old");
            ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
                LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
                processor.setNewName("new");
                try {
                    ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                    processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                    processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            })).join();
            Assert.assertEquals((Object)"new", (Object)document.get());
        }
        finally {
            manager.disconnectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testRenameChangeAlsoExternalFile() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile workspaceFile = TestUtils.createUniqueTestFile(project, "old");
        File externalFile = TestUtils.createTempFile("testRenameChangeAlsoExternalFile", ".lspt");
        Files.write(externalFile.toPath(), "old".getBytes(), new OpenOption[0]);
        HashMap<String, List<TextEdit>> edits = new HashMap<String, List<TextEdit>>(2, 1.0f);
        edits.put(LSPEclipseUtils.toUri((IResource)workspaceFile).toString(), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new")));
        edits.put(LSPEclipseUtils.toUri((File)externalFile).toString(), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new")));
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(new WorkspaceEdit(edits));
        IDocument document = LSPEclipseUtils.getDocument((IResource)workspaceFile);
        Assert.assertNotNull((Object)document);
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            processor.setNewName("new");
            try {
                ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        })).join();
        Assert.assertEquals((Object)"new", (Object)document.get());
        Assert.assertEquals((Object)"new", (Object)new String(Files.readAllBytes(externalFile.toPath())));
    }

    @Test
    public void testRenameHandlerExecution() throws Exception {
        Display display;
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
        editor.selectAndReveal(1, 0);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        Assert.assertTrue((command.isEnabled() && command.isHandled() ? 1 : 0) != 0);
        Event e = new Event();
        e.widget = (Widget)editor.getAdapter(Control.class);
        Shell ideShell = editor.getSite().getShell();
        e.display = display = ideShell.getDisplay();
        AtomicBoolean renameDialogOkPressed = new AtomicBoolean();
        Listener pressOKonRenameDialogPaint = event -> {
            void composite;
            Shell shell2;
            if (renameDialogOkPressed.get()) {
                return;
            }
            Widget widget = event.widget;
            if (widget instanceof Composite var4_5 && (shell2 = composite.getShell()) != ideShell && "Rename".equals(shell2.getText())) {
                event.widget.getDisplay().asyncExec(() -> this.pressOk(shell2));
                renameDialogOkPressed.set(true);
            }
        };
        try {
            display.addFilter(9, pressOKonRenameDialogPaint);
            ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, e);
            command.executeWithChecks(executionEvent);
            TestUtils.waitForAndAssertCondition("Rename dialog not shown", 3000, display, () -> renameDialogOkPressed.get());
            IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
            TestUtils.waitForAndAssertCondition("document not modified, rename not applied", 3000, display, () -> "new".equals(document.get()));
        }
        finally {
            ideShell.getDisplay().removeFilter(9, pressOKonRenameDialogPaint);
        }
    }

    @Test
    public void testPlaceholderUsingPlaceholderFromPrepareRenameResult() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assert.assertNotNull((Object)document);
        AtomicReference placeholder = new AtomicReference();
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            try {
                processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            placeholder.set(processor.getPlaceholder());
        })).join();
        Assert.assertEquals((Object)"placeholder", placeholder.get());
    }

    @Test
    public void testPlaceholderUsingRangeFromPrepareRenameResult() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        Range range = new Range(new Position(0, 1), new Position(0, 3));
        MockLanguageServer.INSTANCE.getTextDocumentService().setPrepareRenameResult(Either.forLeft((Object)range));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        AtomicReference placeholder = new AtomicReference();
        Assert.assertNotNull((Object)document);
        ((CompletableFuture)LanguageServiceAccessor.getLanguageServers((IDocument)document, LSPRenameHandler::isRenameProvider).thenAccept(languageServers -> {
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), 0);
            try {
                processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            placeholder.set(processor.getPlaceholder());
        })).join();
        Assert.assertEquals((Object)"ld", placeholder.get());
    }

    private void pressOk(Shell dialogShell) {
        try {
            Dialog dialog = (Dialog)dialogShell.getData();
            Method okPressedMethod = Dialog.class.getDeclaredMethod("okPressed", new Class[0]);
            okPressedMethod.setAccessible(true);
            okPressedMethod.invoke((Object)dialog, new Object[0]);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static WorkspaceEdit createSimpleMockRenameEdit(URI fileUri) {
        WorkspaceEdit res = new WorkspaceEdit();
        File f = new File(fileUri);
        res.setChanges(Collections.singletonMap(LSPEclipseUtils.toUri((File)f).toString(), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new"))));
        return res;
    }
}

