/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidOpenTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentDidChangeTest" + System.currentTimeMillis());
    }

    @Test
    public void testOpen() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = TestUtils.openEditor(testFile);
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IResource)testFile), capabilites -> Boolean.TRUE);
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastOpen.getTextDocument());
        Assert.assertEquals((Object)"lspt", (Object)lastOpen.getTextDocument().getLanguageId());
    }

    @Test
    public void testOpenExternalFile() throws Exception {
        File file = File.createTempFile("testOpenExternalFile", ".lspt");
        try {
            CompletableFuture didOpenExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
            LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput()), capabilites -> Boolean.TRUE);
            DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)lastOpen.getTextDocument());
            Assert.assertEquals((Object)"lspt", (Object)lastOpen.getTextDocument().getLanguageId());
        }
        finally {
            Files.deleteIfExists(file.toPath());
        }
    }

    @Test
    public void testOpenWithSpecificLanguageId() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = TestUtils.openEditor(testFile);
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IResource)testFile), capabilites -> Boolean.TRUE);
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastOpen.getTextDocument());
        Assert.assertEquals((Object)"differentLanguageId", (Object)lastOpen.getTextDocument().getLanguageId());
        ((AbstractTextEditor)editor).close(false);
    }
}

