/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.color;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.color.ColorInformationMining;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;

public class DocumentColorProvider
extends AbstractCodeMiningProvider {
    private final Map<RGBA, Color> colorTable = new HashMap<RGBA, Color>();

    private CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(@NonNull IDocument document) {
        URI docURI = LSPEclipseUtils.toUri(document);
        if (docURI != null) {
            TextDocumentIdentifier textDocumentIdentifier = new TextDocumentIdentifier(docURI.toString());
            DocumentColorParams param = new DocumentColorParams(textDocumentIdentifier);
            List colorResults = Collections.synchronizedList(new ArrayList());
            return ((CompletableFuture)LanguageServiceAccessor.getLanguageServers(document, DocumentColorProvider::isColorProvider).thenComposeAsync(languageServers -> CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().documentColor(param).thenAcceptAsync(colors -> {
                if (colors != null) {
                    colors.stream().filter(Objects::nonNull).map(color -> {
                        ColorInformationMining mining = null;
                        try {
                            mining = new ColorInformationMining((ColorInformation)color, document, textDocumentIdentifier, (LanguageServer)languageServer, this);
                        }
                        catch (BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                        return mining;
                    }).filter(Objects::nonNull).forEach(colorResults::add);
                }
            })).toArray(CompletableFuture[]::new)))).thenApplyAsync(theVoid -> colorResults);
        }
        return null;
    }

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        IDocument document = viewer.getDocument();
        return document != null ? this.provideCodeMinings(document) : null;
    }

    public Color getColor(RGBA rgba, Display display) {
        return this.colorTable.computeIfAbsent(rgba, key -> new Color((Device)display, rgba));
    }

    private static boolean isColorProvider(ServerCapabilities capabilities) {
        return capabilities.getColorProvider() != null && (capabilities.getColorProvider().getLeft() != null && (Boolean)capabilities.getColorProvider().getLeft() != false || capabilities.getColorProvider().getRight() != null);
    }
}

