/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.references.LSSearchQuery;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSFindReferences
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(part instanceof ITextEditor)) {
            return null;
        }
        ITextEditor editor = (ITextEditor)part;
        IDocument document = LSPEclipseUtils.getDocument(editor);
        if (document == null) {
            return null;
        }
        ISelection sel = editor.getSelectionProvider().getSelection();
        if (!(sel instanceof ITextSelection)) {
            return null;
        }
        int offset = ((ITextSelection)sel).getOffset();
        LanguageServiceAccessor.getLanguageServers(document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getReferencesProvider())).thenAcceptAsync(languageServers -> {
            if (languageServers.isEmpty()) {
                return;
            }
            LanguageServer ls = (LanguageServer)languageServers.get(0);
            try {
                LSSearchQuery query = new LSSearchQuery(document, offset, ls);
                HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().asyncExec(() -> NewSearchUI.runQueryInBackground((ISearchQuery)query));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        });
        return null;
    }

    public boolean isEnabled() {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(part instanceof ITextEditor)) {
            return false;
        }
        ITextEditor editor = (ITextEditor)part;
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return false;
        }
        try {
            return !LanguageServiceAccessor.getLanguageServers(LSPEclipseUtils.getDocument(editor), capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getReferencesProvider())).get(50L, TimeUnit.MILLISECONDS).isEmpty();
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }
}

