/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.lsat.external.api.LSATException;
import org.eclipse.lsat.external.api.LSATService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"osgi.http.whiteboard.servlet.pattern=/api/*", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=default)"})
public class LSATServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_HTML = "text/html";
    private static final String APPLICATION_XML = "application/xml";
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @Reference
    private LSATService lsatService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        try {
            switch (pathInfo) {
                case "/timinganalysis": {
                    this.handleTimingAnalysis(request, response);
                    break;
                }
                case "/health": {
                    this.handleHealth(response);
                    break;
                }
                case "/list": {
                    this.handleList(request, response);
                    break;
                }
                case "/reload": {
                    this.handleReloadProject(request, response);
                    break;
                }
                case "/reloadall": {
                    this.handleReloadAllProjects(request, response);
                    break;
                }
                default: {
                    response.sendError(404);
                    break;
                }
            }
        }
        catch (LSATException e) {
            LSATServiceServlet.error(response, (Exception)((Object)e));
        }
    }

    private void handleHealth(HttpServletResponse response) throws IOException {
        response.setContentType("text");
        PrintWriter writer = response.getWriter();
        writer.write("REST Health OK");
        writer.close();
    }

    private void handleList(HttpServletRequest request, HttpServletResponse response) throws IOException, LSATException {
        Pararameters pars = new Pararameters(request);
        String projectName = pars.stringValue("project");
        LSATService.FileType fileType = LSATService.FileType.valueOf((String)pars.stringValue("type").toUpperCase());
        List result = this.lsatService.list(projectName, fileType);
        response.setContentType(APPLICATION_JSON);
        Throwable throwable = null;
        Object var8_9 = null;
        try (PrintWriter writer = response.getWriter();){
            this.gson.toJson((Object)result, (Appendable)writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleReloadProject(HttpServletRequest request, HttpServletResponse response) throws IOException, LSATException {
        Pararameters pars = new Pararameters(request);
        String projectName = pars.stringValue("project");
        String result = this.lsatService.reloadProject(projectName);
        response.setContentType("text");
        PrintWriter writer = response.getWriter();
        if (result != null) {
            writer.write("Successfully reloaded project: " + projectName);
        } else {
            writer.write("Failed to reload project: " + projectName);
        }
        writer.close();
    }

    private void handleReloadAllProjects(HttpServletRequest request, HttpServletResponse response) throws IOException, LSATException {
        List result = this.lsatService.reloadAllProjects();
        response.setContentType("text");
        PrintWriter writer = response.getWriter();
        writer.write("Reloaded projects:\n");
        for (String r : result) {
            writer.write(" - " + r + "\n");
        }
        writer.close();
    }

    private void handleTimingAnalysis(HttpServletRequest request, HttpServletResponse response) throws IOException, LSATException {
        Pararameters pars = new Pararameters(request);
        String projectName = pars.stringValue("project");
        String dispatchFilename = pars.stringValue("dispatch");
        String settingFilename = pars.stringValue("setting");
        LSATService.TimingAnalysisGoal goal = LSATService.TimingAnalysisGoal.valueOf((String)pars.stringValue("goal", LSATService.TimingAnalysisGoal.NORMAL.name()).toUpperCase());
        int stochasticSampleLength = pars.intValue("sampleLength", 100);
        boolean exportMotionPlots = pars.booleanValue("exportMotionPlots", false);
        int motionPlotSampleFrequency = pars.intValue("motionPlotSampleFrequency", 1000);
        String motionPlotFilter = pars.stringValue("motionPlotFilter", "");
        boolean colorErroneousMoves = pars.booleanValue("colorErroneousMoves", false);
        boolean debug = pars.booleanValue("debug", false);
        String results = this.lsatService.timingAnalysis(projectName, dispatchFilename, settingFilename, goal, stochasticSampleLength, exportMotionPlots, motionPlotSampleFrequency, motionPlotFilter, colorErroneousMoves, debug);
        response.setStatus(200);
        response.setContentType(APPLICATION_JSON);
        response.getWriter().write(results);
    }

    private static void error(HttpServletResponse response, Exception e) throws IOException {
        response.setStatus(500);
        response.setContentType(TEXT_PLAIN);
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = response.getWriter();){
            writer.write("Error: " + e.getMessage() + "\n");
            e.printStackTrace(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class Pararameters {
        private final HttpServletRequest request;

        public Pararameters(HttpServletRequest request) {
            this.request = request;
        }

        private String stringValue(String name, String defValue) {
            String result = this.request.getParameter(name);
            if (result != null) {
                return result;
            }
            return defValue;
        }

        private boolean booleanValue(String name, boolean defValue) {
            String result = this.request.getParameter(name);
            if (result != null) {
                return Boolean.valueOf(result);
            }
            return defValue;
        }

        private int intValue(String name, int defValue) {
            String result = this.request.getParameter(name);
            if (result != null) {
                return Integer.parseInt(result);
            }
            return defValue;
        }

        private String stringValue(String name) {
            String result = this.request.getParameter(name);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Mandatory argument '" + name + "' not specified");
        }

        private boolean booleanValue(String name) {
            return Boolean.valueOf(this.stringValue(name));
        }

        private int intValue(String name) {
            return Integer.parseInt(this.stringValue(name));
        }
    }
}

