/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance;

import activity.Action;
import activity.Claim;
import activity.Release;
import activity.ResourceAction;
import activity.impl.ActivityQueries;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import machine.IResource;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.util.DirectedGraphQueries;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.util.CollectionUtil;
import org.eclipse.lsat.conformance.ConformanceCheckInput;
import org.eclipse.lsat.conformance.internal.ConformanceCheckQueries;
import org.eclipse.lsat.conformance.internal.UniqueTracePoint;
import org.eclipse.lsat.petri_net.PetriNet;
import org.eclipse.lsat.petri_net.Place;
import org.eclipse.lsat.petri_net.Transition;
import org.eclipse.lsat.trace.TraceLine;
import org.eclipse.lsat.trace.TraceModel;

public class ConformanceCheckJava {
    private final HashMap<IResource, Set<UniqueTracePoint>> tracePointsInPlay = new HashMap();
    private final ConformanceCheckInput.Level level;

    public ConformanceCheckJava(ConformanceCheckInput.Level aLevel) {
        this.level = aLevel;
    }

    public PetriNet transformModel(ConformanceCheckInput input) throws QvtoTransformationException {
        this.tracePointsInPlay.clear();
        QueryableIterable traceLines = QueryableIterable.from(input.getTraces()).collect(TraceModel::getLines).sortedBy(TraceLine::getTimestamp);
        Iterable allNodes = DirectedGraphQueries.allSubNodes((DirectedGraph)input.getPetriNet());
        if (ConformanceCheckInput.Level.Dispatching == this.level) {
            Set allTracepoints = QueryableIterable.from((Iterable)allNodes).objectsOfKind(Transition.class).xcollectOne(t -> UniqueTracePoint.create(t.getTracePoint())).asSet();
            this.tracePointsInPlay.put(null, allTracepoints);
        }
        input.getPetriNet().getInitialPlaces().forEach(p -> p.setToken(true));
        LinkedList allPlaces = QueryableIterable.from((Iterable)allNodes).objectsOfKind(Place.class).asList();
        QueryableIterable placesWithToken = QueryableIterable.from((Iterable)allPlaces).select(p -> p.isToken());
        while (this.play((Iterable<Place>)placesWithToken, null)) {
        }
        if (input.getPetriNet().getFinalPlaces().isEmpty()) {
            CollectionUtil.addAll((Collection)input.getPetriNet().getFinalPlaces(), (Iterable)placesWithToken);
        }
        for (TraceLine traceLine : traceLines) {
            if (!this.play((Iterable<Place>)placesWithToken, traceLine)) {
                for (Set<UniqueTracePoint> tracePoints : this.tracePointsInPlay.values()) {
                    if (!UniqueTracePoint.matchesOneOf(traceLine, tracePoints)) continue;
                    throw new QvtoTransformationException(String.format("Trace not expected, see petri net for details. %s, line %s: %s", traceLine.getModel().getName(), traceLine.getLineNumber(), traceLine.getTracePoint()));
                }
            }
            while (this.play((Iterable<Place>)placesWithToken, null)) {
            }
        }
        for (Place place : input.getPetriNet().getFinalPlaces()) {
            if (place.isToken()) continue;
            throw new QvtoTransformationException("Conformance check failed, unexpected end of trace, see petri net for details");
        }
        return input.getPetriNet();
    }

    private void setToken(Iterable<Place> places, boolean token) {
        for (Place place : places) {
            this.setToken(place, token);
        }
    }

    private void setToken(Place place, boolean token) {
        place.setToken(token);
        if (token && ConformanceCheckInput.Level.Claim == this.level) {
            Action action = place.getAction();
            if (action instanceof Claim) {
                IResource resource = ((Claim)action).getResource();
                QueryableIterable actions = ActivityQueries.getActionsFor((IResource)resource, ResourceAction.class, (Iterable)action.getGraph().getNodes());
                Set claimedTracepoints = QueryableIterable.from((Iterable)actions).xcollect(ConformanceCheckQueries::getClaimedTracePoints).asSet();
                this.tracePointsInPlay.put(resource, claimedTracepoints);
            } else if (action instanceof Release) {
                this.tracePointsInPlay.remove(((Release)action).getResource());
            }
        }
    }

    private boolean play(Iterable<Place> places, TraceLine traceLine) {
        for (Place place : places) {
            if (!this.play(place, traceLine)) continue;
            return true;
        }
        return false;
    }

    private boolean play(Place place, TraceLine traceLine) {
        for (Transition transition : QueryableIterable.from((Iterable)place.getOutgoingEdges()).xcollectOne(e -> e.getTargetNode()).objectsOfKind(Transition.class)) {
            if (!this.isEnabled(transition) || !UniqueTracePoint.matches(traceLine, transition.getTracePoint())) continue;
            if (traceLine != null) {
                transition.getTraceLines().add((Object)traceLine);
            }
            QueryableIterable.from((Iterable)transition.getIncomingEdges()).xcollectOne(e -> e.getSourceNode()).objectsOfKind(Place.class).forEach(p -> p.setToken(false));
            QueryableIterable.from((Iterable)transition.getOutgoingEdges()).xcollectOne(e -> e.getTargetNode()).objectsOfKind(Place.class).forEach(p -> p.setToken(true));
            return true;
        }
        return false;
    }

    private boolean isEnabled(Transition transition) {
        for (Place place : QueryableIterable.from((Iterable)transition.getIncomingEdges()).xcollectOne(e -> e.getSourceNode()).objectsOfKind(Place.class)) {
            if (place.isToken()) continue;
            return false;
        }
        return true;
    }
}

