/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.Collections;
import java.util.List;
import org.apache.xerces.xs.XSObjectList;
import org.eclipse.lemminx.extensions.xsd.contentmodel.HtmlToPlainText;
import org.eclipse.lemminx.extensions.xsd.contentmodel.XSDAnnotationModel;
import org.eclipse.lemminx.settings.SchemaDocumentationType;
import org.eclipse.lemminx.utils.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class XSDDocumentation {
    private static final String APPINFO_ELEMENT = "appinfo";
    private static final String DOCUMENTATION_ELEMENT = "documentation";
    private final String prefix;
    private final SchemaDocumentationType strategy;
    private final List<String> documentation;
    private final List<String> appinfo;

    public XSDDocumentation(XSObjectList annotations, SchemaDocumentationType docStrategy, boolean convertToPlainText) {
        this(annotations, null, docStrategy, convertToPlainText);
    }

    public XSDDocumentation(XSObjectList annotations, String value, SchemaDocumentationType docStrategy, boolean convertToPlainText) {
        List<String> documentation = Collections.emptyList();
        List<String> appinfo = Collections.emptyList();
        switch (docStrategy) {
            case all: {
                documentation = XSDAnnotationModel.getDocumentation(annotations, value);
                appinfo = XSDAnnotationModel.getAppInfo(annotations, value);
                break;
            }
            case documentation: {
                documentation = XSDAnnotationModel.getDocumentation(annotations, value);
                break;
            }
            case appinfo: {
                appinfo = XSDAnnotationModel.getAppInfo(annotations, value);
                break;
            }
        }
        if (convertToPlainText) {
            XSDDocumentation.convertToPlainText(documentation);
            XSDDocumentation.convertToPlainText(appinfo);
        }
        this.documentation = documentation;
        this.appinfo = appinfo;
        this.strategy = docStrategy;
        this.prefix = XSDAnnotationModel.getPrefix(annotations, value);
    }

    public String getFormattedDocumentation(boolean html) {
        StringBuilder result = new StringBuilder();
        boolean prependTitles = this.prependTitleCheck();
        result.append(XSDDocumentation.getFormatted(this.prefix, DOCUMENTATION_ELEMENT, this.documentation, prependTitles, html));
        result.append(XSDDocumentation.getFormatted(this.prefix, APPINFO_ELEMENT, this.appinfo, prependTitles, html));
        return result.toString().trim();
    }

    private boolean prependTitleCheck() {
        return this.documentation.size() > 0 && this.appinfo.size() > 0 && this.strategy == SchemaDocumentationType.all;
    }

    private static void convertToPlainText(List<String> list) {
        HtmlToPlainText formatter = new HtmlToPlainText();
        for (int i = 0; i < list.size(); ++i) {
            String curr = list.get(i);
            list.set(i, formatter.getPlainText((Element)Jsoup.parse((String)curr)));
        }
    }

    private static String getFormatted(String prefix, String elementName, List<String> content, boolean prependTitles, boolean html) {
        StringBuilder result = new StringBuilder();
        if (prependTitles) {
            result.append(XSDDocumentation.applyPrefix(prefix, elementName, html));
        }
        for (String doc : content) {
            if (StringUtils.isBlank(doc)) continue;
            if (html) {
                result.append("<p>");
            }
            result.append(doc);
            if (html) {
                result.append("</p>");
                continue;
            }
            result.append(System.lineSeparator());
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    private static String applyPrefix(String prefix, String documentation, boolean html) {
        StringBuilder result = new StringBuilder();
        if (html) {
            result.append("<p><b>");
        }
        if (!StringUtils.isEmpty(prefix)) {
            result.append(prefix).append(':');
        }
        result.append(documentation);
        if (html) {
            result.append("</b>");
        }
        result.append(":");
        if (html) {
            result.append("</p>");
        } else {
            result.append(System.lineSeparator());
            result.append(System.lineSeparator());
        }
        return result.toString();
    }
}

