/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class RelaxNGDiagnosticsV3Test
extends AbstractCacheBasedTest {
    @Test
    public void valid() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook_v3.rng\" ?>\r\n<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void invalidFileRng() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBookXXX.rng\" ?>\r\n<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 17, 64, (IXMLErrorCode)RelaxNGErrorCode.RelaxNGNotFound));
    }

    @Test
    public void unkwown_element() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook_v3.rng\" ?>\r\n<addressBook>\r\n  <card>\r\n    <nameXXX>John Smith</nameXXX>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.unknown_element), XMLAssert.d(4, 5, 10, (IXMLErrorCode)RelaxNGErrorCode.unexpected_element_required_element_missing));
    }

    @Test
    public void incomplete_element_required_element_missing() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook_v3.rng\" ?>\r\n<addressBook>\r\n  <card>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 3, 7, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    @Test
    public void no_attributes_allowed() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook_v3.rng\" ?>\r\n<addressBook id=\"\" >\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 13, 15, (IXMLErrorCode)RelaxNGErrorCode.no_attributes_allowed));
    }

    @Test
    public void multiple_no_attributes_allowed() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook_v3.rng\" ?>\r\n<addressBook id=\"\" name=\"\" >\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 13, 15, (IXMLErrorCode)RelaxNGErrorCode.no_attributes_allowed), XMLAssert.d(1, 19, 23, (IXMLErrorCode)RelaxNGErrorCode.no_attributes_allowed));
    }
}

