/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class RNGValidationTest
extends AbstractCacheBasedTest {
    @Test
    public void missing_start_element_InRoot() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 8, (IXMLErrorCode)RelaxNGErrorCode.missing_start_element));
    }

    @Test
    public void missing_start_element_InNestedElement() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start>\r\n\t\t<grammar></grammar>\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 3, 10, (IXMLErrorCode)RelaxNGErrorCode.missing_start_element));
    }

    @Test
    public void missing_children() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start>\r\n\t\t\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(3, 2, 7, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void illegal_attribute_ignored() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start attr=\"\" >\r\n\t\t\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(3, 8, 12, (IXMLErrorCode)RelaxNGErrorCode.illegal_attribute_ignored), XMLAssert.d(3, 2, 7, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void illegal_name_attribute() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start name=\"\" >\r\n\t\t\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(3, 8, 12, (IXMLErrorCode)RelaxNGErrorCode.illegal_name_attribute), XMLAssert.d(3, 2, 7, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void missing_name_attribute() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <empty />\r\n  </start>\r\n\r\n  <define>\r\n    <empty />\r\n  </define>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(7, 3, 9, (IXMLErrorCode)RelaxNGErrorCode.missing_name_attribute));
    }

    @Test
    public void invalid_ncname_withAttrName() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start>\r\n\t\t<element name=\"\"></element>\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 16, 18, (IXMLErrorCode)RelaxNGErrorCode.invalid_ncname), XMLAssert.d(4, 3, 10, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void invalid_ncname_withNameTag() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <element>\r\n      <name>:::</name>\r\n    </element>\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(5, 12, 15, (IXMLErrorCode)RelaxNGErrorCode.invalid_ncname), XMLAssert.d(5, 12, 15, (IXMLErrorCode)RelaxNGErrorCode.invalid_ncname), XMLAssert.d(4, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void illegal_attribute_ignored_InElementName() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n\t<start>\r\n\t\t<element name=\"::::\"></element>\r\n\t</start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 16, 22, (IXMLErrorCode)RelaxNGErrorCode.invalid_ncname), XMLAssert.d(4, 16, 22, (IXMLErrorCode)RelaxNGErrorCode.invalid_ncname), XMLAssert.d(4, 3, 10, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void expected_pattern() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <foo />\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 5, 8, (IXMLErrorCode)RelaxNGErrorCode.expected_pattern), XMLAssert.d(3, 3, 8, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void missing_name_class() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <element />\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.missing_name_class), XMLAssert.d(4, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.missing_children));
    }

    @Test
    public void missing_type_attribute() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <element name=\"name\">\r\n      <data />\r\n    </element>\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(5, 7, 11, (IXMLErrorCode)RelaxNGErrorCode.missing_type_attribute));
    }

    @Test
    public void duplicate_start() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <element name=\"name\">\r\n      <text />\r\n    </element>\r\n  </start>\r\n\r\n  <start>\r\n    <element name=\"name\">\r\n      <text />\r\n    </element>\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(9, 3, 8, (IXMLErrorCode)RelaxNGErrorCode.duplicate_start));
    }

    public void duplicate_define() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <ref name=\"name\"/>\r\n  </start>\r\n\r\n  <define name=\"name\">\r\n    <empty/>\r\n  </define>\r\n\r\n  <define name=\"name\">\r\n    <empty/>\r\n  </define>\r\n  \r\n  <define name=\"email\">\r\n    <empty/>\r\n  </define>\r\n  \r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(11, 15, 21, (IXMLErrorCode)RelaxNGErrorCode.duplicate_define));
    }

    @Test
    public void reference_to_undefined() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <ref name=\"name\"/>\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(4, 14, 20, (IXMLErrorCode)RelaxNGErrorCode.reference_to_undefined));
    }

    @Test
    public void unrecognized_datatype() throws Exception {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\r\n  <start>\r\n    <choice>\r\n      <element name=\"name\">\r\n        <data type=\"string\" />\r\n      </element>\r\n      <element name=\"email\">\r\n        <data type=\"stringXXX\" />\r\n      </element>\r\n    </choice>\r\n  </start>\r\n\r\n</grammar>";
        RNGValidationTest.testDiagnosticsFor(xml, XMLAssert.d(9, 19, 30, (IXMLErrorCode)RelaxNGErrorCode.unrecognized_datatype));
    }

    private static void testDiagnosticsFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, expected);
    }
}

