/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionList;
import org.junit.jupiter.api.Test;

public class XMLCompletionApplyBasedOnXSDTest
extends BaseFileTempTest {
    @Test
    public void emptyStartTagInText() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n|</employee>";
        CompletionList list = this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 0, "<member$0>"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 0, "<employee$0>"), "employee"));
        CompletionItem memberItem = XMLCompletionApplyBasedOnXSDTest.findItemByLabel(list.getItems(), "member");
        XMLAssert.testCompletionApply(xml, memberItem, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<member$0></member>");
        CompletionItem employeeItem = XMLCompletionApplyBasedOnXSDTest.findItemByLabel(list.getItems(), "employee");
        XMLAssert.testCompletionApply(xml, employeeItem, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee$0></employee>");
    }

    @Test
    public void emptyStartTagInElement() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<|</employee>";
        CompletionList list = this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 1, 2, 1, "member$0>"), "<member"), XMLAssert.c("employee", XMLAssert.te(2, 1, 2, 1, "employee$0>"), "<employee"));
        CompletionItem memberItem = XMLCompletionApplyBasedOnXSDTest.findItemByLabel(list.getItems(), "member");
        XMLAssert.testCompletionApply(xml, memberItem, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<member$0></member>");
        CompletionItem employeeItem = XMLCompletionApplyBasedOnXSDTest.findItemByLabel(list.getItems(), "employee");
        XMLAssert.testCompletionApply(xml, employeeItem, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee$0></employee>");
    }

    private CompletionList testCompletionSnippetSupportFor(String xml, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(true));
        completionItem.setDocumentationFormat(Arrays.asList("markdown"));
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        return XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, null, fileURI, null, sharedSettings, expectedItems);
    }

    private static CompletionItem findItemByLabel(List<CompletionItem> items, String label) {
        for (CompletionItem item : items) {
            if (!label.equals(item.getLabel())) continue;
            return item;
        }
        return null;
    }
}

