/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLFormatterWithXSDGrammarAwareFormattingTest {
    @Test
    public void testXSDForMixedElement() throws Exception {
        String content = "<?xml-model href=\"xsd/mixed-element.xsd\"?>\r\n<mixedElement> text \r\n   content   </mixedElement>\r\n<notMixed> text\r\n  content </notMixed>\r\n";
        String expected = "<?xml-model href=\"xsd/mixed-element.xsd\"?>\r\n<mixedElement> text content </mixedElement>\r\n<notMixed> text\r\n  content </notMixed>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(0);
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(content, expected, settings, XMLAssert.te(1, 19, 2, 3, " "), XMLAssert.te(2, 10, 2, 13, " "), XMLAssert.te(4, 21, 5, 0, ""));
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testXSDForEmptyMixedElement() throws Exception {
        String content;
        String expected = content = "<?xml-model href=\"xsd/mixed-element.xsd\"?>\r\n<mixedElement></mixedElement>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(0);
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        try {
            XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(content, expected, settings, new TextEdit[0]);
        }
        catch (Exception ex) {
            Assertions.fail((String)"Formatter failed to process text", (Throwable)ex);
        }
    }

    @Test
    public void testXSDForPreserveSpaceWithStringContent() throws Exception {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a    b     c</description2>\r\n</project>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a b c</description2>\r\n</project>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(0);
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(content, expected, settings, "test.xml", true, XMLAssert.te(3, 17, 3, 21, " "), XMLAssert.te(3, 22, 3, 27, " "));
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(expected, expected, settings, "test.xml", true, new TextEdit[0]);
    }

    @Test
    public void testXSDForPreserveSpaceWithStringContentWithMaxLineWidth() throws Exception {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a    b     c</description2>\r\n</project>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a b c</description2>\r\n</project>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(content, expected, settings, "test.xml", true, XMLAssert.te(1, 50, 1, 51, "\r\n  "), XMLAssert.te(1, 104, 1, 105, "\r\n  "), XMLAssert.te(3, 17, 3, 21, " "), XMLAssert.te(3, 22, 3, 27, " "));
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(expected, expected, settings, "test.xml", true, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithXSDGrammarAwareFormattingTest.assertFormat(unformatted, expected, sharedSettings, "src/test/resources/test.xml", true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }
}

