/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLFormatterWithDTDGrammarAwareFormattingTest {
    @Test
    public void testDTDForMixedElement() throws BadLocationException {
        String content = "<?xml-model href=\"dtd/mixed-element.dtd\"?>\r\n<mixedElement> text \r\n   content   </mixedElement>\r\n<notMixed> text\r\n  content </notMixed>\r\n";
        String expected = "<?xml-model href=\"dtd/mixed-element.dtd\"?>\r\n<mixedElement> text content </mixedElement>\r\n<notMixed> text\r\n  content </notMixed>";
        XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(content, expected, XMLAssert.te(1, 19, 2, 3, " "), XMLAssert.te(2, 10, 2, 13, " "), XMLAssert.te(4, 21, 5, 0, ""));
        XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testDTDForEmptyMixedElement() throws BadLocationException {
        String content;
        String expected = content = "<?xml-model href=\"dtd/mixed-element.dtd\"?>\r\n<mixedElement></mixedElement>";
        try {
            XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(expected, expected, new TextEdit[0]);
        }
        catch (Exception ex) {
            Assertions.fail((String)"Formatter failed to process text", (Throwable)ex);
        }
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(unformatted, expected, sharedSettings, "src/test/resources/test.xml", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithDTDGrammarAwareFormattingTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

