/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.validator;

import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.eclipse.lemminx.extensions.relaxng.jing.SchemaProvider;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.xml.sax.XMLReader;

public class ExternalRelaxNGValidator
implements XMLComponent,
XMLDocumentFilter {
    public static final String RELAXNG = "http://apache.org/xml/properties/relaxng/external-relaxng";
    private XMLErrorReporter errorReporterForXML;
    private XMLErrorReporter errorReporterForGrammar;
    private XMLLocator locator;
    private String externalRelaxNG;
    private boolean processed;
    private XMLEntityResolver entityResolver;
    private XMLReader xmlReader;
    private XMLGrammarPool grammarPool;
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final XMLLocator NULL_LOCATOR = new XMLLocator(){

        public String getXMLVersion() {
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public String getLiteralSystemId() {
            return null;
        }

        public int getLineNumber() {
            return 0;
        }

        public String getExpandedSystemId() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public int getColumnNumber() {
            return 0;
        }

        public int getCharacterOffset() {
            return 0;
        }

        public String getBaseSystemId() {
            return null;
        }
    };

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.setLocator(locator);
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(target, data, augs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (!this.processed) {
            try {
                if (this.externalRelaxNG != null && this.xmlReader != null) {
                    String location = null;
                    try {
                        location = XMLEntityManager.expandSystemId((String)this.externalRelaxNG, (String)this.locator.getBaseSystemId(), (boolean)false);
                        Schema schema = SchemaProvider.getSchema(this.externalRelaxNG, this.locator.getBaseSystemId(), this.entityResolver, this.errorReporterForGrammar, this.grammarPool);
                        SchemaProvider.validate(schema, this.xmlReader, this.errorReporterForXML);
                    }
                    catch (IncorrectSchemaException schema) {
                    }
                    catch (Exception e) {
                        this.errorReporterForXML.reportError(NULL_LOCATOR, "https://relaxng.org/", RelaxNGErrorCode.RelaxNGNotFound.getCode(), new Object[]{null, location}, (short)1, e);
                    }
                }
            }
            finally {
                this.processed = true;
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.startElement(element, attributes, augs);
        }
    }

    public void setExternalRelaxNG(String externalRelaxNG) {
        this.externalRelaxNG = externalRelaxNG;
    }

    public void setLocator(XMLLocator locator) {
        this.locator = locator;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        try {
            this.setExternalRelaxNG((String)componentManager.getProperty(RELAXNG));
        }
        catch (XMLConfigurationException e) {
            this.setExternalRelaxNG(null);
        }
        try {
            this.errorReporterForXML = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        }
        catch (XMLConfigurationException e) {
            this.errorReporterForXML = null;
        }
        try {
            this.errorReporterForGrammar = (XMLErrorReporter)componentManager.getProperty("http://apache.org/xml/properties/internal/error-reporter-grammar");
        }
        catch (XMLConfigurationException e) {
            this.errorReporterForGrammar = null;
        }
        try {
            this.entityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException e) {
            this.entityResolver = null;
        }
        try {
            this.grammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException e) {
            this.grammarPool = null;
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(element, attributes, augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(name, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(text, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(element, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(augs);
        }
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.documentSource = source;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.documentHandler = handler;
        if (this.documentHandler instanceof XMLReader) {
            this.xmlReader = (XMLReader)this.documentHandler;
        }
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return null;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }
}

