/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.CodeLensRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLCodeLens {
    private final XMLExtensionsRegistry extensionsRegistry;
    private static final Logger LOGGER = Logger.getLogger(XMLCodeLens.class.getName());

    public XMLCodeLens(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<? extends CodeLens> getCodelens(DOMDocument xmlDocument, XMLCodeLensSettings settings, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        CodeLensRequest request = new CodeLensRequest(xmlDocument, settings);
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        for (ICodeLensParticipant participant : this.extensionsRegistry.getCodeLensParticipants()) {
            try {
                participant.doCodeLens(request, lenses, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing code lens for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        cancelChecker.checkCanceled();
        return lenses;
    }
}

