/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.utils;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.extensions.relaxng.jing.RelaxNGGrammar;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelaxNGUtils {
    private static final String REF_TAG = "ref";
    private static final String INCLUDE_TAG = "include";
    private static final String EXTERNAL_REF_TAG = "externalRef";
    private static final String DEFINE_TAG = "define";
    private static final String NAME_ATTR = "name";
    private static final String HREF_ATTR = "href";

    public static FilesChangedTracker createFilesChangedTracker(RelaxNGGrammar grammar) {
        FilesChangedTracker tracker = new FilesChangedTracker();
        String relaxNGURI = RelaxNGUtils.getRelaxNGURI(grammar);
        if (relaxNGURI != null && URIUtils.isFileResource(relaxNGURI)) {
            tracker.addFileURI(relaxNGURI);
        }
        return tracker;
    }

    private static String getRelaxNGURI(RelaxNGGrammar grammar) {
        return grammar.getGrammarDescription().getExpandedSystemId();
    }

    public static BindingType getBindingType(DOMAttr originAttr) {
        String name;
        if (originAttr != null && NAME_ATTR.equals(name = originAttr.getName()) && REF_TAG.equals(originAttr.getOwnerElement().getLocalName())) {
            return BindingType.DEFINE;
        }
        return BindingType.NONE;
    }

    public static void searchRNGTargetAttributes(DOMAttr originAttr, BindingType bindingType, boolean matchAttr, boolean searchInExternalSchema, BiConsumer<String, DOMAttr> collector) {
        DOMElement documentElement;
        if (bindingType == BindingType.NONE) {
            return;
        }
        DOMDocument document = originAttr.getOwnerDocument();
        DOMElement dOMElement = documentElement = document != null ? document.getDocumentElement() : null;
        if (documentElement == null) {
            return;
        }
        String originAttrValue = originAttr.getValue();
        if (matchAttr && StringUtils.isEmpty(originAttrValue)) {
            return;
        }
        String targetNamespacePrefix = null;
        int index = originAttrValue.indexOf(58);
        if (index != -1) {
            targetNamespacePrefix = originAttrValue.substring(0, index);
        }
        String originName = null;
        if (matchAttr) {
            originName = RelaxNGUtils.getOriginName(originAttrValue, targetNamespacePrefix);
        }
        RelaxNGUtils.searchRNGTargetAttributes(originAttr, bindingType, matchAttr, collector, documentElement, targetNamespacePrefix, originName, new HashSet<String>(), searchInExternalSchema);
    }

    private static void searchRNGTargetAttributes(DOMAttr originAttr, BindingType bindingType, boolean matchAttr, BiConsumer<String, DOMAttr> collector, DOMElement documentElement, String targetNamespacePrefix, String originName, Set<String> visitedURIs, boolean searchInExternalSchema) {
        if (visitedURIs != null) {
            DOMDocument document = documentElement.getOwnerDocument();
            String documentURI = document.getDocumentURI();
            if (visitedURIs.contains(documentURI)) {
                return;
            }
            visitedURIs.add(documentURI);
        }
        HashSet<String> externalURIS = null;
        DOMElement parent = documentElement;
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            DOMElement targetElement = (DOMElement)node;
            if (RelaxNGUtils.isBounded(originAttr.getOwnerElement(), bindingType, targetElement)) {
                DOMAttr targetAttr = targetElement.getAttributeNode(NAME_ATTR);
                if (targetAttr == null || matchAttr && !Objects.equal((Object)originName, (Object)targetAttr.getValue())) continue;
                collector.accept(targetNamespacePrefix, targetAttr);
                continue;
            }
            if (RelaxNGUtils.isInclude(targetElement) || RelaxNGUtils.isExternalRef(targetElement)) {
                String schemaLocation = targetElement.getAttribute(HREF_ATTR);
                if (schemaLocation == null) continue;
                if (externalURIS == null) {
                    externalURIS = new HashSet<String>();
                }
                externalURIS.add(schemaLocation);
                continue;
            }
            RelaxNGUtils.searchRNGTargetAttributes(originAttr, bindingType, matchAttr, collector, targetElement, targetNamespacePrefix, originName, null, false);
        }
        if (searchInExternalSchema && externalURIS != null) {
            DOMDocument document = documentElement.getOwnerDocument();
            String documentURI = document.getDocumentURI();
            URIResolverExtensionManager resolverExtensionManager = document.getResolverExtensionManager();
            for (String externalURI : externalURIS) {
                DOMDocument externalDocument;
                String resourceURI = resolverExtensionManager.resolve(documentURI, null, externalURI);
                if (!URIUtils.isFileResource(resourceURI) || (externalDocument = DOMUtils.loadDocument(resourceURI, document.getResolverExtensionManager())) == null) continue;
                RelaxNGUtils.searchRNGTargetAttributes(originAttr, bindingType, matchAttr, collector, externalDocument.getDocumentElement(), targetNamespacePrefix, originName, visitedURIs, searchInExternalSchema);
            }
        }
    }

    private static String getOriginName(String originAttrValue, String targetNamespacePrefix) {
        int index = originAttrValue.indexOf(":");
        if (index != -1) {
            String prefix = originAttrValue.substring(0, index);
            if (!Objects.equal((Object)prefix, (Object)targetNamespacePrefix)) {
                return null;
            }
            return originAttrValue.substring(index + 1, originAttrValue.length());
        }
        return originAttrValue;
    }

    private static boolean isBounded(Element originElement, BindingType originBinding, Element targetElement) {
        if (originBinding == BindingType.DEFINE) {
            return RelaxNGUtils.isDefine(targetElement);
        }
        return false;
    }

    public static void searchRNGOriginAttributes(DOMNode targetNode, BiConsumer<DOMAttr, DOMAttr> collector, CancelChecker cancelChecker) {
        List<DOMAttr> targetAttrs = RelaxNGUtils.getTargetAttrs(targetNode);
        if (targetAttrs.isEmpty()) {
            return;
        }
        DOMDocument document = targetNode.getOwnerDocument();
        DOMElement documentElement = document.getDocumentElement();
        String targetNamespacePrefix = null;
        NodeList nodes = documentElement.getChildNodes();
        RelaxNGUtils.searchRNGOriginAttributes(nodes, targetAttrs, targetNamespacePrefix, collector, cancelChecker);
    }

    private static List<DOMAttr> getTargetAttrs(DOMNode referencedNode) {
        if (referencedNode == null) {
            return Collections.emptyList();
        }
        ArrayList<DOMAttr> targetAttrs = new ArrayList<DOMAttr>();
        DOMDocument document = referencedNode.getOwnerDocument();
        switch (referencedNode.getNodeType()) {
            case 1: 
            case 2: {
                RelaxNGUtils.addTargetNode(referencedNode, targetAttrs);
                break;
            }
            case 9: {
                Element documentElement = document.getDocumentElement();
                if (documentElement == null) break;
                Element parent = documentElement;
                RelaxNGUtils.addTargetAttrs(parent, targetAttrs);
            }
        }
        return targetAttrs;
    }

    private static void addTargetAttrs(Node parent, List<DOMAttr> targetAttrs) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)n;
            if (RelaxNGUtils.isRNGTargetElement(element)) {
                RelaxNGUtils.addTargetNode(element, targetAttrs);
            }
            RelaxNGUtils.addTargetAttrs(n, targetAttrs);
        }
    }

    private static void addTargetNode(DOMNode node, List<DOMAttr> targetAttrs) {
        DOMAttr attr = null;
        switch (node.getNodeType()) {
            case 2: {
                attr = (DOMAttr)node;
                break;
            }
            case 1: {
                attr = ((DOMElement)node).getAttributeNode(NAME_ATTR);
            }
        }
        if (attr != null && !StringUtils.isEmpty(attr.getValue())) {
            targetAttrs.add(attr);
        }
    }

    private static void searchRNGOriginAttributes(NodeList nodes, List<DOMAttr> targetAttrs, String targetNamespacePrefix, BiConsumer<DOMAttr, DOMAttr> collector, CancelChecker cancelChecker) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            DOMElement originElement;
            NamedNodeMap originAttributes;
            Node node;
            if (cancelChecker != null) {
                cancelChecker.checkCanceled();
            }
            if ((node = nodes.item(i)).getNodeType() == 1 && (originAttributes = (originElement = (DOMElement)node).getAttributes()) != null) {
                for (int j = 0; j < originAttributes.getLength(); ++j) {
                    DOMAttr originAttr = (DOMAttr)originAttributes.item(j);
                    BindingType originBnding = RelaxNGUtils.getBindingType(originAttr);
                    if (originBnding == BindingType.NONE) continue;
                    String originName = RelaxNGUtils.getOriginName(originAttr.getValue(), targetNamespacePrefix);
                    for (DOMAttr targetAttr : targetAttrs) {
                        DOMElement targetElement = targetAttr.getOwnerElement();
                        if (!RelaxNGUtils.isBounded(originAttr.getOwnerElement(), originBnding, targetElement) || targetAttr == null || !Objects.equal((Object)originName, (Object)targetAttr.getValue())) continue;
                        collector.accept(originAttr, targetAttr);
                    }
                }
            }
            if (!node.hasChildNodes()) continue;
            RelaxNGUtils.searchRNGOriginAttributes(node.getChildNodes(), targetAttrs, targetNamespacePrefix, collector, cancelChecker);
        }
    }

    public static boolean isInclude(Element element) {
        return element != null && INCLUDE_TAG.equals(element.getLocalName());
    }

    public static boolean isExternalRef(Element element) {
        return element != null && EXTERNAL_REF_TAG.equals(element.getLocalName());
    }

    public static boolean isDefine(Element element) {
        return element != null && DEFINE_TAG.equals(element.getLocalName());
    }

    public static boolean isRNGTargetElement(Element element) {
        return RelaxNGUtils.isDefine(element);
    }

    public static DOMAttr getHref(DOMElement element) {
        if (!RelaxNGUtils.isInclude(element) && !RelaxNGUtils.isExternalRef(element)) {
            return null;
        }
        return element.getAttributeNode(HREF_ATTR);
    }

    public static enum BindingType {
        DEFINE,
        NONE;

    }
}

