/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.CodeLens;
import org.junit.jupiter.api.Test;

public class RNGCodeLensExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void codeLensOnDefineElement() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardContent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardContent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        XMLAssert.testCodeLensFor(xml, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "http://relaxng.org/ns/structure/1.0 (with embedded relaxng.rng)", "xml.open.uri"), XMLAssert.cl(XMLAssert.r(11, 12, 11, 30), "1 reference", "xml.show.references"));
    }

    @Test
    public void codeLensOnNestedDefineElement() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n  <start>\r\n    <ref name=\"root-element\"/>\r\n  </start>\r\n  <define name=\"root-element\">\r\n      <element name=\"root-element\">\r\n        <ref name=\"asdf\"></ref>\r\n      </element>\r\n  </define>\r\n  <div>\r\n    <div>\r\n      <define name=\"asdf\">\r\n        <attribute name=\"child\"></attribute>\r\n      </define>\r\n    </div>\r\n  </div>\r\n</grammar>";
        XMLAssert.testCodeLensFor(xml, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "http://relaxng.org/ns/structure/1.0 (with embedded relaxng.rng)", "xml.open.uri"), XMLAssert.cl(XMLAssert.r(5, 10, 5, 29), "1 reference", "xml.show.references"), XMLAssert.cl(XMLAssert.r(12, 14, 12, 25), "1 reference", "xml.show.references"));
    }

    @Test
    public void codeLensEmptyDocument() throws BadLocationException {
        String xml = "";
        XMLAssert.testCodeLensFor(xml, new CodeLens[0]);
    }

    @Test
    public void codeLensSpace() throws BadLocationException {
        String xml = " ";
        XMLAssert.testCodeLensFor(xml, new CodeLens[0]);
    }
}

