/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.TextEdit;

public class DOMElementFormatter {
    private final XMLFormatterDocumentNew formatterDocument;
    private final DOMAttributeFormatter attributeFormatter;

    public DOMElementFormatter(XMLFormatterDocumentNew formatterDocument, DOMAttributeFormatter attributeFormatter) {
        this.formatterDocument = formatterDocument;
        this.attributeFormatter = attributeFormatter;
    }

    public void formatElement(DOMElement element, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements(element);
        int indentLevel = parentConstraints.getIndentLevel();
        int nb = this.formatStartTagElement(element, parentConstraints, emptyElements, start, end, edits);
        if (emptyElements == XMLFormattingOptions.EmptyElements.ignore) {
            XMLFormattingConstraints constraints = new XMLFormattingConstraints();
            constraints.copyConstraints(parentConstraints);
            if (element.isClosed()) {
                constraints.setIndentLevel(indentLevel + 1);
            }
            constraints.setFormatElementCategory(this.getFormatElementCategory(element, parentConstraints));
            constraints.setAvailableLineWidth(this.getMaxLineWidth() - nb);
            this.formatChildren(element, constraints, start, end, edits);
            if (element.hasEndTag()) {
                this.formatEndTagElement(element, parentConstraints, constraints, edits);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int formatStartTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingOptions.EmptyElements emptyElements, int start, int end, List<TextEdit> edits) {
        if (!element.hasStartTag()) {
            return element.getEnd() - element.getStart();
        }
        width = 0;
        indentLevel = parentConstraints.getIndentLevel();
        formatElementCategory = parentConstraints.getFormatElementCategory();
        startTagOpenOffset = element.getStartTagOpenOffset();
        startTagCloseOffset = element.getStartTagCloseOffset();
        v0 = addLineSeparator = element.getParentElement() == null && element.getPreviousSibling() == null;
        if (end != -1 && startTagOpenOffset > end || start != -1 && startTagCloseOffset != -1 && startTagCloseOffset < start) {
            return 0;
        }
        switch (1.$SwitchMap$org$eclipse$lemminx$services$format$FormatElementCategory[formatElementCategory.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                parentStartCloseOffset = element.getParentElement().getStartTagCloseOffset() + 1;
                if (parentStartCloseOffset == startTagOpenOffset || !StringUtils.isWhitespace(this.formatterDocument.getText(), parentStartCloseOffset, startTagOpenOffset)) break;
                nbSpaces = this.replaceLeftSpacesWithIndentation(indentLevel, parentStartCloseOffset, startTagOpenOffset, addLineSeparator == false, edits);
                v1 = width = element.getTagName() != null ? nbSpaces + element.getTagName().length() + 1 : nbSpaces;
                if (addLineSeparator) break;
                width -= this.formatterDocument.getLineDelimiter().length();
                break;
            }
            case 3: {
                preservedNewLines = this.getPreservedNewlines();
                currentNewLineCount = XMLFormatterDocumentNew.getExistingNewLineCount(this.formatterDocument.getText(), startTagOpenOffset, this.formatterDocument.getLineDelimiter());
                if (currentNewLineCount <= preservedNewLines) ** GOTO lbl29
                this.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, 0, startTagOpenOffset, preservedNewLines + 1, edits);
                ** GOTO lbl33
lbl29:
                // 1 sources

                nbSpaces = this.replaceLeftSpacesWithIndentation(indentLevel, 0, startTagOpenOffset, addLineSeparator == false, edits);
                v2 = width = element.getTagName() != null ? nbSpaces + element.getTagName().length() + 1 : nbSpaces;
                if (!addLineSeparator) {
                    width -= this.formatterDocument.getLineDelimiter().length();
                }
            }
lbl33:
            // 5 sources

            case 4: {
                ++width;
            }
        }
        parentConstraints.setAvailableLineWidth(parentConstraints.getAvailableLineWidth() - width);
        if (formatElementCategory != FormatElementCategory.PreserveSpace) {
            this.formatAttributes(element, parentConstraints, edits);
            formatted = false;
            switch (1.$SwitchMap$org$eclipse$lemminx$settings$XMLFormattingOptions$EmptyElements[emptyElements.ordinal()]) {
                case 1: {
                    if (!element.isSelfClosed()) break;
                    tag = new StringBuilder();
                    tag.append(">");
                    tag.append("</");
                    tag.append(element.getTagName());
                    tag.append('>');
                    from = DOMElementFormatter.getOffsetAfterStartTagOrLastAttribute(element);
                    to = element.getEnd();
                    this.createTextEditIfNeeded(from, to, tag.toString(), edits);
                    formatted = true;
                    break;
                }
                case 2: {
                    if (element.isSelfClosed() || end != -1 && element.getEndTagOpenOffset() + 1 >= end || !this.shouldCollapseEmptyElement(element, this.formatterDocument.getSharedSettings())) break;
                    tag = new StringBuilder();
                    if (this.isSpaceBeforeEmptyCloseTag()) {
                        tag.append(" ");
                    }
                    tag.append("/>");
                    from = DOMElementFormatter.getOffsetAfterStartTagOrLastAttribute(element);
                    to = element.getEnd();
                    this.createTextEditIfNeeded(from, to, tag.toString(), edits);
                    formatted = true;
                    break;
                }
            }
            if (!formatted && (element.isStartTagClosed() || element.isSelfClosed())) {
                this.formatElementStartTagOrSelfClosed(element, parentConstraints, edits);
            }
        }
        return width;
    }

    private static int getOffsetAfterStartTagOrLastAttribute(DOMElement element) {
        DOMAttr attr = DOMElementFormatter.getLastAttribute(element);
        if (attr != null) {
            return attr.getEnd();
        }
        return element.getOffsetAfterStartTag();
    }

    private int formatAttributes(DOMElement element, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        if (element.hasAttributes()) {
            List<DOMAttr> attributes = element.getAttributeNodes();
            int prevOffset = element.getOffsetAfterStartTag();
            boolean singleAttribute = attributes.size() == 1;
            for (DOMAttr attr : attributes) {
                this.attributeFormatter.formatAttribute(attr, prevOffset, singleAttribute, true, parentConstraints, edits);
                prevOffset = attr.getEnd();
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void formatElementStartTagOrSelfClosed(DOMElement element, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        int startTagClose = element.getOffsetBeforeCloseOfStartTag();
        int startTagOpen = element.getOffsetAfterStartTag();
        String replace = "";
        boolean spaceBeforeEmptyCloseTag = this.isSpaceBeforeEmptyCloseTag();
        if (this.isPreserveAttributeLineBreaks() && element.hasAttributes() && this.hasLineBreak(DOMElementFormatter.getLastAttribute(element).getEnd(), startTagClose)) {
            spaceBeforeEmptyCloseTag = false;
            int indentLevel = parentConstraints.getIndentLevel();
            if (indentLevel != 0) {
                this.replaceLeftSpacesWithIndentation(indentLevel, startTagOpen, startTagClose, true, edits);
                return;
            }
            replace = this.formatterDocument.getLineDelimiter();
        } else if (this.shouldFormatClosingBracketNewLine(element)) {
            int indentLevel = parentConstraints.getIndentLevel();
            this.replaceLeftSpacesWithIndentation(indentLevel + this.getSplitAttributesIndentSize(), startTagOpen, startTagClose, true, edits);
            return;
        }
        if (element.isSelfClosed() && spaceBeforeEmptyCloseTag) {
            replace = replace + " ";
        }
        this.replaceLeftSpacesWith(startTagOpen, startTagClose, replace, edits);
    }

    private int formatEndTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingConstraints constraints, List<TextEdit> edits) {
        int indentLevel = parentConstraints.getIndentLevel();
        FormatElementCategory formatElementCategory = constraints.getFormatElementCategory();
        int endTagOffset = element.getEndTagOpenOffset();
        int startTagCloseOffset = element.getStartTagCloseOffset();
        switch (formatElementCategory) {
            case PreserveSpace: {
                break;
            }
            case MixedContent: {
                if (!element.getLastChild().isElement() && !element.getLastChild().isComment() || !Character.isWhitespace(this.formatterDocument.getText().charAt(endTagOffset - 1)) || this.isPreserveEmptyContent()) break;
                this.replaceLeftSpacesWithIndentation(indentLevel, startTagCloseOffset, endTagOffset, true, edits);
                break;
            }
            case IgnoreSpace: {
                int preservedNewLines = this.getPreservedNewlines();
                int currentNewLineCount = XMLFormatterDocumentNew.getExistingNewLineCount(this.formatterDocument.getText(), endTagOffset, this.formatterDocument.getLineDelimiter());
                if (currentNewLineCount > preservedNewLines) {
                    this.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, startTagCloseOffset, endTagOffset, preservedNewLines + 1, edits);
                    break;
                }
                this.replaceLeftSpacesWithIndentation(indentLevel, startTagCloseOffset, endTagOffset, true, edits);
                break;
            }
        }
        if (element.isEndTagClosed()) {
            int endTagCloseOffset = element.getEndTagCloseOffset();
            this.removeLeftSpaces(element.getEndTagOpenOffset(), endTagCloseOffset, edits);
        }
        return 0;
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements(DOMElement element) {
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements();
        if (emptyElements != XMLFormattingOptions.EmptyElements.ignore && element.isClosed() && element.isEmpty()) {
            switch (emptyElements) {
                case expand: 
                case collapse: {
                    if (this.isPreserveEmptyContent() && element.hasChildNodes()) {
                        return XMLFormattingOptions.EmptyElements.ignore;
                    }
                    return emptyElements;
                }
            }
            return emptyElements;
        }
        return XMLFormattingOptions.EmptyElements.ignore;
    }

    private boolean shouldFormatClosingBracketNewLine(DOMElement element) {
        boolean isSingleAttribute = element.getAttributeNodes() != null ? element.getAttributeNodes().size() == 1 : true;
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getClosingBracketNewLine() && this.isSplitAttributes() && !isSingleAttribute;
    }

    private void replaceLeftSpacesWith(int from, int to, String replace, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(from, to, replace, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private int replaceLeftSpacesWithIndentationWithMultiNewLines(int indentLevel, int from, int to, int newLineCount, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, from, to, newLineCount, edits);
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private void createTextEditIfNeeded(int from, int to, String expectedContent, List<TextEdit> edits) {
        this.formatterDocument.createTextEditIfNeeded(from, to, expectedContent, edits);
    }

    private boolean hasLineBreak(int from, int to) {
        return this.formatterDocument.hasLineBreak(from, to);
    }

    private static DOMAttr getLastAttribute(DOMElement element) {
        if (!element.hasAttributes()) {
            return null;
        }
        List<DOMAttr> attributes = element.getAttributeNodes();
        return attributes.get(attributes.size() - 1);
    }

    private int getPreservedNewlines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getPreservedNewlines();
    }

    private boolean isPreserveAttributeLineBreaks() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveAttributeLineBreaks();
    }

    private boolean isSplitAttributes() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSplitAttributes();
    }

    private int getSplitAttributesIndentSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getSplitAttributesIndentSize();
    }

    private boolean isSpaceBeforeEmptyCloseTag() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSpaceBeforeEmptyCloseTag();
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getEmptyElements();
    }

    private boolean isPreserveEmptyContent() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveEmptyContent();
    }

    private void formatChildren(DOMElement element, XMLFormattingConstraints constraints, int start, int end, List<TextEdit> edits) {
        this.formatterDocument.formatChildren(element, constraints, start, end, edits);
    }

    private FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints) {
        return this.formatterDocument.getFormatElementCategory(element, parentConstraints);
    }

    private boolean shouldCollapseEmptyElement(DOMElement element, SharedSettings settings) {
        return this.formatterDocument.shouldCollapseEmptyElement(element, settings);
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }
}

