/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.TextEdit;

public class DOMDocTypeFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMDocTypeFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatDocType(DOMDocumentType docType, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        boolean isDTD = docType.getOwnerDocument().isDTD();
        if (isDTD) {
            this.formatDTD(docType, parentConstraints, start, end, edits);
        } else {
            this.replaceLeftSpacesWithIndentation(parentConstraints.getIndentLevel(), docType.getParentNode().getStart(), docType.getStart(), true, edits);
            List<DTDDeclParameter> parameters = docType.getParameters();
            if (!parameters.isEmpty()) {
                for (DTDDeclParameter parameter : parameters) {
                    this.replaceLeftSpacesWithOneSpace(docType.getStart(), parameter.getStart(), edits);
                    if (!docType.isInternalSubset(parameter)) continue;
                    XMLFormattingConstraints constraints = new XMLFormattingConstraints();
                    constraints.copyConstraints(parentConstraints);
                    constraints.setIndentLevel(constraints.getIndentLevel() + 1);
                    this.formatDTD(docType, constraints, start, end, edits);
                }
                if (this.getEnforceQuoteStyle() == EnforceQuoteStyle.preferred) {
                    int quoteStart = DOMDocTypeFormatter.getDocTypeIdStart(docType);
                    int quoteEnd = DOMDocTypeFormatter.getDocTypeIdEnd(docType);
                    if (quoteStart != -1 && quoteEnd != -1) {
                        this.formatterDocument.replaceQuoteWithPreferred(quoteStart, quoteStart + 1, edits);
                        this.formatterDocument.replaceQuoteWithPreferred(quoteEnd - 1, quoteEnd, edits);
                    }
                }
            }
        }
        DTDDeclParameter internalSubset = docType.getInternalSubsetNode();
        if (internalSubset == null) {
            if (docType.isClosed()) {
                int startDocType = docType.getStart();
                int endDocType = docType.getEnd() - 1;
                this.removeLeftSpaces(startDocType, endDocType, edits);
            }
        } else {
            int startDocType = internalSubset.getStart();
            int endDocType = internalSubset.getEnd() - 1;
            String lineDelimiter = this.formatterDocument.getLineDelimiter();
            this.replaceLeftSpacesWith(startDocType, endDocType, lineDelimiter, edits);
            this.removeLeftSpaces(internalSubset.getEnd(), docType.getEnd() - 1, edits);
        }
    }

    private void formatDTD(DOMDocumentType docType, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        boolean addLineSeparator = !docType.getOwnerDocument().isDTD();
        block3: for (DOMNode child : docType.getChildren()) {
            switch (child.getNodeType()) {
                case 6: 
                case 101: 
                case 102: 
                case 104: {
                    DTDDeclNode nodeDecl = (DTDDeclNode)child;
                    this.formatDTDNodeDecl(nodeDecl, parentConstraints, addLineSeparator, edits);
                    addLineSeparator = true;
                    continue block3;
                }
            }
            this.formatterDocument.format(child, parentConstraints, start, end, edits);
            int width = this.updateLineWidthWithLastLine(child, parentConstraints.getAvailableLineWidth());
            parentConstraints.setAvailableLineWidth(width);
        }
    }

    private int updateLineWidthWithLastLine(DOMNode child, int availableLineWidth) {
        return this.formatterDocument.updateLineWidthWithLastLine(child, availableLineWidth);
    }

    private void formatDTDNodeDecl(DTDDeclNode nodeDecl, XMLFormattingConstraints parentConstraints, boolean addLineSeparator, List<TextEdit> edits) {
        block15: {
            block14: {
                DTDAttlistDecl attlist;
                this.replaceLeftSpacesWithIndentation(parentConstraints.getIndentLevel(), nodeDecl.getParentNode().getStart(), nodeDecl.getStart(), addLineSeparator, edits);
                DTDAttlistDecl dTDAttlistDecl = attlist = nodeDecl.isDTDAttListDecl() ? (DTDAttlistDecl)nodeDecl : null;
                if (attlist == null) break block14;
                int indentLevel = nodeDecl.getOwnerDocument().isDTD() ? 1 : 2;
                List<DTDAttlistDecl> internalDecls = attlist.getInternalChildren();
                if (internalDecls == null) {
                    int previousOffset = attlist.getStart();
                    for (DTDDeclParameter parameter : attlist.getParameters()) {
                        this.replaceLeftSpacesWithOneSpace(previousOffset, parameter.getStart(), edits);
                        this.replaceQuoteWithPreferred(nodeDecl, parameter, edits);
                        previousOffset = parameter.getEnd();
                    }
                } else {
                    DTDDeclParameter parameter;
                    boolean multipleInternalAttlistDecls = false;
                    List<DTDDeclParameter> params = attlist.getParameters();
                    int previousOffset = attlist.getStart();
                    for (int i = 0; i < params.size(); ++i) {
                        parameter = params.get(i);
                        if (attlist.getNameParameter().equals(parameter)) {
                            this.replaceLeftSpacesWithOneSpace(previousOffset, parameter.getStart(), edits);
                            if (attlist.getParameters().size() > 1) {
                                multipleInternalAttlistDecls = true;
                            }
                        } else if (multipleInternalAttlistDecls && i == 1) {
                            this.replaceLeftSpacesWithIndentation(indentLevel, previousOffset, parameter.getStart(), true, edits);
                        } else {
                            this.replaceLeftSpacesWithOneSpace(previousOffset, parameter.getStart(), edits);
                        }
                        previousOffset = parameter.getEnd();
                    }
                    for (DTDAttlistDecl attlistDecl : internalDecls) {
                        params = attlistDecl.getParameters();
                        previousOffset = attlistDecl.getStart();
                        for (int i = 0; i < params.size(); ++i) {
                            parameter = params.get(i);
                            if (i == 0) {
                                this.replaceLeftSpacesWithIndentation(indentLevel, previousOffset, parameter.getStart(), true, edits);
                            } else {
                                this.replaceLeftSpacesWithOneSpace(previousOffset, parameter.getStart(), edits);
                            }
                            previousOffset = parameter.getEnd();
                        }
                    }
                }
                break block15;
            }
            List<DTDDeclParameter> parameters = nodeDecl.getParameters();
            if (parameters.isEmpty()) break block15;
            int previousOffset = nodeDecl.getStart();
            for (DTDDeclParameter parameter : parameters) {
                this.replaceLeftSpacesWithOneSpace(previousOffset, parameter.getStart(), edits);
                this.replaceQuoteWithPreferred(nodeDecl, parameter, edits);
                previousOffset = parameter.getEnd();
            }
        }
    }

    private void replaceLeftSpacesWith(int from, int to, String replacement, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(from, to, replacement, edits);
    }

    private void replaceLeftSpacesWithOneSpace(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithOneSpace(from, to, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private EnforceQuoteStyle getEnforceQuoteStyle() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getEnforceQuoteStyle();
    }

    private static int getDocTypeIdStart(DOMDocumentType docType) {
        if (docType.getPublicIdNode() != null) {
            return docType.getPublicIdNode().getStart();
        }
        if (docType.getSystemIdNode() != null) {
            return docType.getSystemIdNode().getStart();
        }
        return -1;
    }

    private static int getDocTypeIdEnd(DOMDocumentType docType) {
        if (docType.getPublicIdNode() != null) {
            return docType.getPublicIdNode().getEnd();
        }
        if (docType.getSystemIdNode() != null) {
            return docType.getSystemIdNode().getEnd();
        }
        return -1;
    }

    private void replaceQuoteWithPreferred(DTDDeclNode nodeDecl, DTDDeclParameter parameter, List<TextEdit> edits) {
        int paramStart = parameter.getStart();
        int paramEnd = parameter.getEnd();
        if (StringUtils.isQuote(nodeDecl.getOwnerDocument().getText().charAt(paramStart)) && StringUtils.isQuote(nodeDecl.getOwnerDocument().getText().charAt(paramEnd - 1)) && this.getEnforceQuoteStyle() == EnforceQuoteStyle.preferred) {
            this.formatterDocument.replaceQuoteWithPreferred(paramStart, paramStart + 1, edits);
            this.formatterDocument.replaceQuoteWithPreferred(paramEnd - 1, paramEnd, edits);
        }
    }
}

