/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.AbstractPositionRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

class CompletionRequest
extends AbstractPositionRequest
implements ICompletionRequest {
    private final SharedSettings sharedSettings;
    private Range replaceRange;
    private XMLGenerator generator;
    private boolean hasOpenBracket;
    private boolean addQuotes;

    public CompletionRequest(DOMDocument xmlDocument, Position position, SharedSettings settings, XMLExtensionsRegistry extensionsRegistry) throws BadLocationException {
        super(xmlDocument, position, extensionsRegistry);
        this.sharedSettings = settings;
    }

    @Override
    protected DOMNode findNodeAt(DOMDocument xmlDocument, int offset) {
        return xmlDocument.findNodeBefore(offset);
    }

    @Override
    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    public void setReplaceRange(Range replaceRange) {
        this.replaceRange = replaceRange;
    }

    @Override
    public Range getReplaceRange() {
        return this.replaceRange;
    }

    @Override
    public XMLGenerator getXMLGenerator() throws BadLocationException {
        if (this.generator == null) {
            this.generator = new XMLGenerator(this.getSharedSettings(), this.isAutoCloseTags(), this.getLineIndentInfo().getWhitespacesIndent(), this.getLineIndentInfo().getLineDelimiter(), this.isCompletionSnippetsSupported(), 0, this.getNode());
        }
        return this.generator;
    }

    @Override
    public String getFilterForStartTagName(String tagName) {
        if (this.hasOpenBracket) {
            return "<" + tagName;
        }
        return tagName;
    }

    public void setHasOpenBracket(boolean hasOpenBracket) {
        this.hasOpenBracket = hasOpenBracket;
    }

    public void setAddQuotes(boolean addQuotes) {
        this.addQuotes = addQuotes;
    }

    public boolean isAddQuotes() {
        return this.addQuotes;
    }

    @Override
    public String getInsertAttrValue(String value) {
        if (!this.addQuotes) {
            return value;
        }
        String quotation = this.sharedSettings.getPreferences().getQuotationAsString();
        return quotation + value + quotation;
    }

    @Override
    public boolean canSupportMarkupKind(String kind) {
        XMLCompletionSettings completionSettings = this.sharedSettings.getCompletionSettings();
        return completionSettings.getCompletionCapabilities() != null && completionSettings.getCompletionCapabilities().getCompletionItem() != null && completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat() != null && completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat().contains(kind);
    }

    @Override
    public boolean isCompletionSnippetsSupported() {
        return this.sharedSettings.getCompletionSettings().isCompletionSnippetsSupported();
    }

    @Override
    public boolean isAutoCloseTags() {
        return this.sharedSettings.getCompletionSettings().isAutoCloseTags();
    }

    @Override
    public InsertTextFormat getInsertTextFormat() {
        return this.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText;
    }

    @Override
    public boolean isResolveDocumentationSupported() {
        XMLCompletionSettings completionSettings = this.sharedSettings.getCompletionSettings();
        return completionSettings.isResolveDocumentationSupported();
    }
}

