/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.ExternalRelaxNGValidator;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.ExternalXMLDTDValidator;
import org.eclipse.lemminx.extensions.xerces.LSPSecurityManager;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityManager;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelAwareParserConfiguration;

class LSPXMLParserConfiguration
extends XMLModelAwareParserConfiguration {
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private final boolean disableDTDValidation;
    private ExternalXMLDTDValidator externalDTDValidator;
    private ExternalRelaxNGValidator externalRelaxNGValidator;

    public LSPXMLParserConfiguration(XMLGrammarPool grammarPool, boolean disableDTDValidation, LSPErrorReporterForXML reporterForXML, LSPErrorReporterForXML reporterForGrammar, LSPXMLEntityManager entityManager, XMLValidationSettings validationSettings) {
        super(null, grammarPool, reporterForGrammar);
        this.disableDTDValidation = disableDTDValidation;
        boolean disallowDocTypeDecl = validationSettings != null ? validationSettings.isDisallowDocTypeDecl() : false;
        super.setFeature("http://apache.org/xml/features/disallow-doctype-decl", disallowDocTypeDecl);
        boolean resolveExternalEntities = validationSettings != null ? validationSettings.isResolveExternalEntities() : false;
        super.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
        super.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
        SecurityManager securityManager = LSPSecurityManager.getSecurityManager();
        super.setProperty(SECURITY_MANAGER, (Object)securityManager);
        this.fErrorReporter = reporterForXML;
        this.fEntityManager = entityManager;
        this.fProperties.put("http://apache.org/xml/properties/internal/entity-manager", this.fEntityManager);
        this.addCommonComponent((XMLComponent)this.fEntityManager);
    }

    protected void reset() throws XNIException {
        super.reset();
        if (this.disableDTDValidation) {
            this.disableDTDValidation();
        }
    }

    private void disableDTDValidation() {
        XMLDTDValidator validator = (XMLDTDValidator)super.getProperty("http://apache.org/xml/properties/internal/validator/dtd");
        if (validator != null) {
            XMLComponentManager disableDTDComponent = new XMLComponentManager(){

                public Object getProperty(String propertyId) throws XMLConfigurationException {
                    return LSPXMLParserConfiguration.this.getProperty(propertyId);
                }

                public boolean getFeature(String featureId) throws XMLConfigurationException {
                    if ("http://xml.org/sax/features/validation".equals(featureId)) {
                        return false;
                    }
                    return LSPXMLParserConfiguration.this.getFeature(featureId);
                }
            };
            validator.reset(disableDTDComponent);
        }
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        this.configureExternalDTDPipeline();
        this.configureExternalRelaxNGPipeline();
    }

    @Override
    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configureExternalDTDPipeline();
        this.configureExternalRelaxNGPipeline();
    }

    private void configureExternalDTDPipeline() {
        if (this.externalDTDValidator == null) {
            this.externalDTDValidator = new ExternalXMLDTDValidator();
            this.addCommonComponent((XMLComponent)this.externalDTDValidator);
            this.externalDTDValidator.reset((XMLComponentManager)this);
        }
        XMLDocumentSource prev = null;
        if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
            prev = this.fSchemaValidator.getDocumentSource();
        } else {
            prev = this.fLastComponent;
            this.fLastComponent = this.externalDTDValidator;
        }
        XMLDocumentHandler next = prev.getDocumentHandler();
        prev.setDocumentHandler((XMLDocumentHandler)this.externalDTDValidator);
        this.externalDTDValidator.setDocumentSource(prev);
        if (next != null) {
            this.externalDTDValidator.setDocumentHandler(next);
            next.setDocumentSource((XMLDocumentSource)this.externalDTDValidator);
        }
        if (this.fSchemaValidator != null) {
            LSPXMLEntityManager entityManager = new LSPXMLEntityManager((AbstractLSPErrorReporter)this.fErrorReporter, null);
            AbstractLSPErrorReporter.initializeReporter(this.fSchemaValidator, this.getReporterForGrammar(), (XMLEntityManager)entityManager);
        }
    }

    private void configureExternalRelaxNGPipeline() {
        if (this.externalRelaxNGValidator == null) {
            this.externalRelaxNGValidator = new ExternalRelaxNGValidator();
            this.addCommonComponent(this.externalRelaxNGValidator);
            this.externalRelaxNGValidator.reset((XMLComponentManager)this);
        }
        XMLDocumentSource prev = null;
        if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
            prev = this.fSchemaValidator.getDocumentSource();
        } else {
            prev = this.fLastComponent;
            this.fLastComponent = this.externalRelaxNGValidator;
        }
        XMLDocumentHandler next = prev.getDocumentHandler();
        prev.setDocumentHandler((XMLDocumentHandler)this.externalRelaxNGValidator);
        this.externalRelaxNGValidator.setDocumentSource(prev);
        if (next != null) {
            this.externalRelaxNGValidator.setDocumentHandler(next);
            next.setDocumentSource((XMLDocumentSource)this.externalRelaxNGValidator);
        }
    }

    @Override
    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if ("http://apache.org/xml/properties/relaxng/external-relaxng".equals(propertyId)) {
            return;
        }
        super.checkProperty(propertyId);
    }
}

