/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterPreserveEmptyContentTest {
    @Test
    public void testPreserveEmptyContentTag() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n     </a>";
        String expected = "<a>\n     </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTag() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        String content = "<a>\n     </a>";
        String expected = "<a> </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 5, " "));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveTextContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n   aaa  </a>";
        String expected = "<a>\n   aaa  </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveTextContent2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        String content = "<a>\n   aaa  </a>";
        String expected = "<a> aaa </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 6, 1, 8, " "));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblings() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n       <b>  </b>     </a>";
        String expected = "<a>\n  <b>  </b>\n</a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 7, "\n  "), XMLAssert.te(1, 16, 1, 21, "\n"));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n   zz     <b>  </b>tt     </a>";
        String expected = "<a>\n   zz     <b>  </b>tt     </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTagWithSiblingContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        String content = "<a>\n   zz     <b>  </b>tt     </a>";
        String expected = "<a> zz <b> </b>tt </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 1, 10, " "), XMLAssert.te(1, 13, 1, 15, " "), XMLAssert.te(1, 21, 1, 26, " "));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingWithComment() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n   zz    <b>  </b>tt <!-- Comment -->     </a>";
        String expected = "<a>\n   zz    <b>  </b>tt <!-- Comment -->     </a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingWithNewLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<a>\n   zz    \n<b>\n  </b>\ntt <!-- Comment -->     </a>\n\n<c></c>";
        String expected = "<a>\n   zz    \n<b>\n  </b>\ntt <!-- Comment -->     </a>\n<c></c>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(4, 28, 6, 0, "\n"));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTagWithSiblingWithComment() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        String content = "<a>\n   zz    <b>  </b>tt <!-- Comment -->     </a>";
        String expected = "<a> zz <b> </b>tt <!-- Comment -->\n</a>";
        XMLFormatterPreserveEmptyContentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 1, 9, " "), XMLAssert.te(1, 12, 1, 14, " "), XMLAssert.te(1, 37, 1, 42, "\n"));
        XMLFormatterPreserveEmptyContentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveEmptyContentTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveEmptyContentTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

