/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterEmptyElementsTest
extends AbstractCacheBasedTest {
    @Test
    public void expandEmptyElements() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.expand);
        String content = "<example att=\"hello\" />";
        String expected = "<example att=\"hello\"></example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 20, 0, 23, "></example>"));
        content = "<example " + System.lineSeparator() + "  att=\"hello\"" + System.lineSeparator() + "  />";
        expected = "<example" + System.lineSeparator() + "  att=\"hello\"></example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 1, 2, System.lineSeparator() + "  "), XMLAssert.te(1, 13, 2, 4, "></example>"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void expandEmptyElementsMalformedIssue650() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.expand);
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<c>\r\n  <b>\r\n    <a/></a>\r\n  </b>\r\n</c>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<c>\r\n  <b>\r\n    <a></a>\r\n    </a>\r\n  </b>\r\n</c>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(3, 6, 3, 8, "></a>"), XMLAssert.te(3, 8, 3, 8, "\r\n    "));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElements() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        settings.getFormattingSettings().setGrammarAwareFormatting(false);
        String content = "<example att=\"hello\"></example>";
        String expected = "<example att=\"hello\" />";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 20, 0, 31, " />"));
        content = "<example   att=\"hello\"" + System.lineSeparator() + "  >" + System.lineSeparator() + "</example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 11, " "), XMLAssert.te(0, 22, 2, 10, " />"));
        content = "<example att=\"hello\">   </example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 20, 0, 34, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
        content = "<example att=\"hello\"> X </example>";
        expected = "<example att=\"hello\"> X </example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, new TextEdit[0]);
        content = "<example att=\"hello\"> <X/> </example>";
        expected = "<example att=\"hello\">" + System.lineSeparator() + "  <X />" + System.lineSeparator() + "</example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 21, 0, 22, System.lineSeparator() + "  "), XMLAssert.te(0, 24, 0, 24, " "), XMLAssert.te(0, 26, 0, 27, System.lineSeparator()));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void ignoreEmptyElements() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.ignore);
        String content = "<example att=\"hello\"></example>";
        XMLFormatterEmptyElementsTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<example att=\"hello\"   />";
        String expected = "<example att=\"hello\" />";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 20, 0, 23, " "));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void expandEmptyElementsAndPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.expand);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String content = "<foo>\r\n    <bar>\r\n\r\n\r\n\r\n\r\n\r\n        \r\n    </bar>\r\n</foo>";
        String expected = "<foo>\r\n  <bar>\r\n\r\n\r\n\r\n\r\n\r\n        \r\n    </bar>\r\n</foo>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 4, "\r\n  "));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
        content = "<foo>\r\n    <bar></bar>\r\n</foo>";
        expected = "<foo>\r\n  <bar></bar>\r\n</foo>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 4, "\r\n  "));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsAndPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setGrammarAwareFormatting(false);
        String content = "<foo>\r\n    <bar>\r\n\r\n\r\n\r\n\r\n\r\n        \r\n    </bar>\r\n</foo>";
        String expected = "<foo>\r\n  <bar>\r\n\r\n\r\n\r\n\r\n\r\n        \r\n    </bar>\r\n</foo>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 4, "\r\n  "));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
        content = "<foo>\r\n    <bar></bar>\r\n</foo>";
        expected = "<foo>\r\n  <bar />\r\n</foo>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 4, "\r\n  "), XMLAssert.te(1, 8, 1, 15, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsInRange() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        settings.getFormattingSettings().setGrammarAwareFormatting(false);
        String content = "<a>\r\n<|b>\r\n   | \r\n</b>\r\n</a>";
        String expected = "<a>\r\n<b>\r\n    \r\n</b>\r\n</a>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, new TextEdit[0]);
        content = "<a>\r\n<|b>\r\n    \r\n</|b>\r\n</a>";
        expected = "<a>\r\n<b />\r\n</a>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(1, 2, 3, 4, " />"));
    }

    @Test
    public void collapseEmptyElementsNotBoundWithGrammar() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        String content = "<foo>\r\n    <bar></bar>\r\n</foo>";
        String expected = "<foo>\r\n  <bar />\r\n</foo>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 4, "\r\n  "), XMLAssert.te(1, 8, 1, 15, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsWithGrammarCanBeEmpty() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/isEmpty.xsd\">\r\n  <empty></empty>\r\n</root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/isEmpty.xsd\">\r\n  <empty />\r\n</root>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(3, 8, 3, 17, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsWithGrammarCanBeEmptyNotDefinedInXSD() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/isEmpty.xsd\">\r\n  <empty xsi:nil=\"true\"></empty>\r\n</root>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsWithGrammarCanBeEmptyNil() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/nil.xsd\">\r\n  <nillable xsi:nil=\"true\"></nillable>\r\n</root>";
        String expected = "<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/nil.xsd\">\r\n  <nillable xsi:nil=\"true\" />\r\n</root>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(2, 26, 2, 38, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void collapseEmptyElementsWithGrammarCanBeEmptyNilDontCollapse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/nil.xsd\">\r\n  <nillable></nillable>\r\n</root>";
        String expected = "<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/nil.xsd\">\r\n  <nillable />\r\n</root>";
        XMLFormatterEmptyElementsTest.assertFormat(content, expected, settings, XMLAssert.te(2, 11, 2, 23, " />"));
        XMLFormatterEmptyElementsTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterEmptyElementsTest.assertFormat(unformatted, expected, sharedSettings, "test.xml", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterEmptyElementsTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

